/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.database.ds;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Instant;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.database.ds.SimpleConnection;
import org.dbsyncer.sdk.util.DatabaseUtil;

public class SimpleDataSource
implements DataSource,
AutoCloseable {
    private final int MAX_IDLE = 128;
    private final int MAX_PULL_TIME = 20;
    private AtomicInteger activeNum = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final BlockingQueue<SimpleConnection> pool = new LinkedBlockingQueue<SimpleConnection>(128);
    private final long KEEP_ALIVE = 60000L;
    private final int VALID_TIMEOUT_SECONDS = 10;
    private String driverClassName;
    private String url;
    private String username;
    private String password;

    public SimpleDataSource(String driverClassName, String url, String username, String password) {
        this.driverClassName = driverClassName;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        try {
            this.lock.lock();
            if (this.activeNum.get() >= 128) {
                throw new SdkException(String.format("\u6570\u636e\u5e93\u8fde\u63a5\u6570\u8d85\u8fc7\u4e0a\u9650%d\uff0curl=%s", 128, this.url));
            }
            int time = 20;
            while (time-- > 0) {
                SimpleConnection poll = (SimpleConnection)this.pool.poll();
                if (null == poll) {
                    SimpleConnection simpleConnection = this.createConnection();
                    return simpleConnection;
                }
                if (!poll.isValid(10) || this.isExpired(poll)) {
                    this.closeQuietly(poll);
                    continue;
                }
                SimpleConnection simpleConnection = poll;
                return simpleConnection;
            }
            SimpleConnection simpleConnection = this.createConnection();
            return simpleConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SdkException("Unsupported method.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public void close() {
        this.pool.forEach(c -> c.close());
    }

    public void close(Connection connection) {
        if (connection != null && connection instanceof SimpleConnection) {
            SimpleConnection simpleConnection = (SimpleConnection)connection;
            if (this.isExpired(simpleConnection)) {
                this.closeQuietly(simpleConnection);
                return;
            }
            this.pool.offer(simpleConnection);
        }
    }

    private void closeQuietly(SimpleConnection connection) {
        if (connection != null) {
            connection.close();
            this.activeNum.decrementAndGet();
        }
    }

    private boolean isExpired(SimpleConnection connection) {
        return connection.getActiveTime() + 60000L < Instant.now().toEpochMilli();
    }

    private SimpleConnection createConnection() throws SQLException {
        SimpleConnection simpleConnection = null;
        try {
            simpleConnection = new SimpleConnection(DatabaseUtil.getConnection(this.driverClassName, this.url, this.username, this.password), StringUtil.equals((CharSequence)this.driverClassName, (CharSequence)"oracle.jdbc.OracleDriver"));
            this.activeNum.incrementAndGet();
        }
        catch (SQLException e) {
            throw new SdkException(e);
        }
        return simpleConnection;
    }
}

