/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.connector.schema;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.connector.AbstractValueMapper;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.postgresql.util.PGobject;

public class VarcharValueMapper
extends AbstractValueMapper<String> {
    @Override
    protected String convert(ConnectorInstance connectorInstance, Object val) {
        if (val instanceof byte[]) {
            return new String((byte[])val);
        }
        if (val instanceof Integer) {
            return Integer.toString((Integer)val);
        }
        if (val instanceof LocalDateTime) {
            return ((LocalDateTime)val).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        if (val instanceof LocalDate) {
            return ((LocalDate)val).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        if (val instanceof java.sql.Date) {
            return DateFormatUtil.dateToString((java.sql.Date)((java.sql.Date)val));
        }
        if (val instanceof Date) {
            return DateFormatUtil.dateToString((Date)((Date)val));
        }
        if (val instanceof PGobject) {
            PGobject pgObject = (PGobject)val;
            return pgObject.getValue();
        }
        throw new SdkException(String.format("%s can not find type [%s], val [%s]", this.getClass().getSimpleName(), val.getClass(), val));
    }
}

