/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.listener;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.enums.QuartzFilterEnum;
import org.dbsyncer.sdk.listener.AbstractQuartzListener;
import org.dbsyncer.sdk.listener.QuartzFilter;
import org.dbsyncer.sdk.model.Point;
import org.springframework.util.Assert;

public final class DatabaseQuartzListener
extends AbstractQuartzListener {
    @Override
    protected Point checkLastPoint(Map<String, String> command, int index) {
        String query = command.get("QUERY");
        AtomicBoolean reversed = new AtomicBoolean();
        AtomicLong lastIndex = new AtomicLong();
        List filterEnums = Stream.of(QuartzFilterEnum.values()).sorted(Comparator.comparing(QuartzFilterEnum::getIndex)).filter(f -> {
            int currentIndex = StringUtil.indexOf((CharSequence)query, (CharSequence)f.getType());
            Assert.isTrue((currentIndex == StringUtil.lastIndexOf((CharSequence)query, (CharSequence)f.getType()) ? 1 : 0) != 0, (String)String.format("\u7cfb\u7edf\u53c2\u6570%s\u5b58\u5728\u591a\u4e2a.", f.getType()));
            boolean exist = StringUtil.contains((CharSequence)query, (CharSequence)f.getType());
            if (exist && !reversed.get()) {
                reversed.set(lastIndex.get() > (long)currentIndex);
                lastIndex.set(currentIndex);
            }
            return exist;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterEnums)) {
            return new Point(command, new ArrayList<Object>());
        }
        Point point = new Point();
        String replaceQuery = query;
        String replaceQueryCursor = command.get("QUERY_CURSOR");
        for (QuartzFilterEnum quartzFilter : filterEnums) {
            Object val;
            String type = quartzFilter.getType();
            QuartzFilter f2 = quartzFilter.getQuartzFilter();
            replaceQuery = this.replaceType(replaceQuery, type);
            replaceQueryCursor = this.replaceType(replaceQueryCursor, type);
            String key = index + type;
            if (f2.begin()) {
                if (!this.snapshot.containsKey(key)) {
                    val = f2.getObject();
                    point.addArg(val);
                    this.snapshot.put(key, f2.toString(val));
                    continue;
                }
                val = f2.getObject((String)this.snapshot.get(key));
                point.addArg(val);
                point.setBeginKey(key);
                point.setBeginValue(f2.toString(f2.getObject()));
                continue;
            }
            val = f2.getObject();
            point.addArg(val);
            point.setBeginValue(f2.toString(val));
        }
        point.setCommand("QUERY", replaceQuery);
        if (StringUtil.isNotBlank((CharSequence)replaceQueryCursor)) {
            point.setCommand("QUERY_CURSOR", replaceQueryCursor);
        }
        if (reversed.get()) {
            point.reverseArgs();
        }
        return point;
    }

    private String replaceType(String replaceQuery, String type) {
        return StringUtil.isNotBlank((CharSequence)replaceQuery) ? StringUtil.replace((String)replaceQuery, (String)("'" + type + "'"), (String)"?") : replaceQuery;
    }
}

