/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.listener.filter;

import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.sdk.listener.QuartzFilter;

public class YesDateFilter
implements QuartzFilter<Date> {
    private boolean begin;

    public YesDateFilter(boolean begin) {
        this.begin = begin;
    }

    @Override
    public Date getObject() {
        LocalDateTime localDateTime = !this.begin ? LocalDateTime.now().minusDays(1L).withHour(23).withMinute(59).withSecond(59).withNano(999999999) : LocalDateTime.now().minusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        return new Date(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    @Override
    public Date getObject(String s) {
        return DateFormatUtil.stringToDate((String)s);
    }

    @Override
    public String toString(Date value) {
        return DateFormatUtil.dateToString((Date)value);
    }

    @Override
    public boolean begin() {
        return this.begin;
    }
}

