/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.sdk.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dbsyncer.common.model.Paging;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.sdk.NullExecutorException;
import org.dbsyncer.sdk.SdkException;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.enums.StorageStrategyEnum;
import org.dbsyncer.sdk.filter.BooleanFilter;
import org.dbsyncer.sdk.filter.Query;
import org.dbsyncer.sdk.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;

public abstract class AbstractStorageService
implements StorageService,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Lock lock = new ReentrantLock();

    protected abstract Paging select(String var1, Query var2);

    protected abstract void delete(String var1, Query var2);

    protected abstract void deleteAll(String var1);

    protected abstract void batchInsert(StorageEnum var1, String var2, List<Map> var3);

    protected abstract void batchUpdate(StorageEnum var1, String var2, List<Map> var3);

    protected abstract void batchDelete(StorageEnum var1, String var2, List<String> var3);

    protected String getSharding(StorageEnum type, String collectionId) {
        Assert.notNull((Object)((Object)type), (String)"StorageEnum type can not be null.");
        return StorageStrategyEnum.getStrategy(type).createSharding(this.getSeparator(), collectionId);
    }

    protected String getSeparator() {
        return File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging query(Query query) {
        boolean locked = false;
        try {
            locked = this.lock.tryLock(3L, TimeUnit.SECONDS);
            if (locked) {
                String sharding = this.getSharding(query.getType(), query.getMetaId());
                Paging paging = this.select(sharding, query);
                return paging;
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("tryLock error", (Object)e.getLocalizedMessage());
        }
        catch (NullExecutorException nullExecutorException) {
        }
        finally {
            if (locked) {
                this.lock.unlock();
            }
        }
        return new Paging(query.getPageNum(), query.getPageSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Query query) {
        BooleanFilter q = query.getBooleanFilter();
        if (CollectionUtils.isEmpty(q.getClauses()) && CollectionUtils.isEmpty(q.getFilters())) {
            throw new SdkException("\u5fc5\u987b\u5305\u542b\u5220\u9664\u6761\u4ef6");
        }
        boolean locked = false;
        try {
            locked = this.lock.tryLock();
            if (locked) {
                String sharding = this.getSharding(query.getType(), query.getMetaId());
                this.delete(sharding, query);
            }
        }
        catch (NullExecutorException nullExecutorException) {
        }
        finally {
            if (locked) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(StorageEnum type, String metaId) {
        try {
            this.lock.lock();
            String sharding = this.getSharding(type, metaId);
            this.deleteAll(sharding);
        }
        catch (NullExecutorException nullExecutorException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void add(StorageEnum type, Map params) {
        this.add(type, null, params);
    }

    @Override
    public void add(StorageEnum type, String metaId, Map params) {
        this.addBatch(type, metaId, this.newArrayList(params));
    }

    @Override
    public void addBatch(StorageEnum type, String metaId, List<Map> list) {
        if (!CollectionUtils.isEmpty(list)) {
            this.batchInsert(type, this.getSharding(type, metaId), list);
        }
    }

    @Override
    public void edit(StorageEnum type, Map params) {
        this.edit(type, null, params);
    }

    @Override
    public void edit(StorageEnum type, String metaId, Map params) {
        this.editBatch(type, metaId, this.newArrayList(params));
    }

    @Override
    public void editBatch(StorageEnum type, String metaId, List<Map> list) {
        if (!CollectionUtils.isEmpty(list)) {
            this.batchUpdate(type, this.getSharding(type, metaId), list);
        }
    }

    @Override
    public void remove(StorageEnum type, String id) {
        this.remove(type, null, id);
    }

    @Override
    public void remove(StorageEnum type, String metaId, String id) {
        this.removeBatch(type, metaId, this.newArrayList(id));
    }

    @Override
    public void removeBatch(StorageEnum type, String metaId, List<String> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            this.batchDelete(type, this.getSharding(type, metaId), ids);
        }
    }

    private List<Map> newArrayList(Map params) {
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(params);
        return list;
    }

    private List<String> newArrayList(String id) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(id);
        return list;
    }
}

