/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.common.config;

import java.time.LocalDate;
import org.dbsyncer.common.util.StringUtil;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="info.app")
public class AppConfig {
    private String name = "DBSyncer";
    private String version;
    private String copyright;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCopyright() {
        if (StringUtil.isBlank(this.copyright)) {
            StringBuilder copy = new StringBuilder();
            copy.append("&copy;").append(LocalDate.now().getYear()).append(" ");
            copy.append(this.name);
            copy.append("(").append(this.version).append(")");
            copy.append("<footer>Designed By <a href='https://gitee.com/ghi/dbsyncer' target='_blank' >AE86</a></footer>");
            this.copyright = copy.toString();
        }
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }
}

