/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.common.config;

import org.dbsyncer.common.config.BufferActuatorConfig;
import org.dbsyncer.common.util.ThreadPoolUtil;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConfigurationProperties(prefix="dbsyncer.parser.general")
public class GeneralBufferConfig
extends BufferActuatorConfig {
    private int threadCoreSize = Runtime.getRuntime().availableProcessors() * 2;
    private int maxThreadSize = 16;
    private int threadQueueCapacity = 1000;

    @Bean(name={"generalExecutor"}, destroyMethod="shutdown")
    public ThreadPoolTaskExecutor generalExecutor() {
        return ThreadPoolUtil.newThreadPoolTaskExecutor(this.threadCoreSize, this.maxThreadSize, this.threadQueueCapacity, 30, "GeneralExecutor-");
    }

    public int getThreadCoreSize() {
        return this.threadCoreSize;
    }

    public void setThreadCoreSize(int threadCoreSize) {
        this.threadCoreSize = threadCoreSize;
    }

    public int getMaxThreadSize() {
        return this.maxThreadSize;
    }

    public void setMaxThreadSize(int maxThreadSize) {
        this.maxThreadSize = maxThreadSize;
    }

    public int getThreadQueueCapacity() {
        return this.threadQueueCapacity;
    }

    public void setThreadQueueCapacity(int threadQueueCapacity) {
        this.threadQueueCapacity = threadQueueCapacity;
    }
}

