/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.common.util;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AESEncyptUtil {
    private static final Logger logger = LoggerFactory.getLogger(AESEncyptUtil.class);
    public static String keySeed = "c32ad1415f6c89fee76d8457c31efb4b";

    public static String encrypt(String content, String keyseed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyseed.getBytes("UTF-8"));
        kgen.init(128, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        byte[] byteContent = content.getBytes("utf-8");
        cipher.init(1, key);
        byte[] result = cipher.doFinal(byteContent);
        return AESEncyptUtil.byte2Hex(result);
    }

    public static byte[] decrypt(byte[] content, String keyseed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyseed.getBytes("UTF-8"));
        kgen.init(128, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        byte[] result = cipher.doFinal(AESEncyptUtil.hex2Byte(content));
        return result;
    }

    public static String decrypt(String content, String keyseed) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(keyseed.getBytes("UTF-8"));
        kgen.init(128, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        String result = new String(cipher.doFinal(AESEncyptUtil.hex2Byte(content.getBytes("UTF-8"))), "UTF-8");
        return result.trim();
    }

    public static String encryptForJS(String content, String keyseed) throws Exception {
        SecretKeySpec key = AESEncyptUtil.getKeySpecFromBytes(keyseed.toUpperCase());
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] byteEnc = cipher.doFinal(content.getBytes("UTF-8"));
        return AESEncyptUtil.byte2Hex(byteEnc);
    }

    public static String decryptForJS(String content, String keyseed) throws Exception {
        SecretKeySpec key = AESEncyptUtil.getKeySpecFromBytes(keyseed.toUpperCase());
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, key);
        String result = new String(cipher.doFinal(AESEncyptUtil.hex2Byte(content.getBytes("UTF-8"))), "UTF-8");
        return result.trim();
    }

    private static String byte2Hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    private static byte[] hex2Byte(byte[] b) {
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u662f\u5076\u6570!");
        }
        byte[] b2 = new byte[b.length / 2];
        for (int n = 0; n < b.length; n += 2) {
            try {
                String item = null;
                if (n + 2 <= b.length) {
                    item = new String(b, n, 2, "UTF-8");
                    b2[n / 2] = (byte)Integer.parseInt(item, 16);
                }
                item = "";
                item = null;
                continue;
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        byte temp = 0;
        Arrays.fill(b, temp);
        return b2;
    }

    private static SecretKeySpec getKeySpecFromBytes(String strBytes) throws NoSuchAlgorithmException {
        SecretKeySpec spec = null;
        try {
            spec = new SecretKeySpec(AESEncyptUtil.hex2Byte(strBytes.getBytes("UTF-8")), "AES");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            spec = new SecretKeySpec(AESEncyptUtil.hex2Byte(strBytes.getBytes("UTF-8")), "AES");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return spec;
    }
}

