/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.dbsyncer.common.CommonException;

public abstract class BeanUtil {
    public static Object mapToBean(Map<String, String> map, Object instance) {
        try {
            Class<?> clazz = instance.getClass();
            for (Map.Entry<String, String> eachMap : map.entrySet()) {
                String property = eachMap.getKey();
                String value = eachMap.getValue();
                String setMethod = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
                Field field = BeanUtil.getField(property, clazz);
                Class<?> fType = field.getType();
                Object newValue = BeanUtil.convert(value, fType);
                clazz.getMethod(setMethod, fType).invoke(instance, newValue);
            }
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
        return instance;
    }

    public static Map beanToMap(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Field[] field = object.getClass().getDeclaredFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field fi : field) {
            String property = fi.getName();
            String getMe = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Object obj = object.getClass().getMethod(getMe, new Class[0]).invoke(object, new Object[0]);
            map.put(property, obj);
        }
        return map;
    }

    private static Object convert(String value, Class<?> fType) {
        if (Long.class.getName().equals(fType.getName()) || Long.TYPE.getName().equals(fType.getName())) {
            return Long.parseLong(value);
        }
        if (Float.class.getName().equals(fType.getName()) || Float.TYPE.getName().equals(fType.getName())) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.getName().equals(fType.getName()) || Double.TYPE.getName().equals(fType.getName())) {
            return Double.parseDouble(value);
        }
        if (Integer.class.getName().equals(fType.getName()) || Integer.TYPE.getName().equals(fType.getName())) {
            return Integer.parseInt(value);
        }
        if (Boolean.class.getName().equals(fType.getName()) || Boolean.TYPE.getName().equals(fType.getName())) {
            return Boolean.valueOf(value);
        }
        return value;
    }

    private static Field getField(String property, Class<?> obj) {
        Field[] field;
        if (Object.class.getName().equals(obj.getName())) {
            return null;
        }
        for (Field f : field = obj.getDeclaredFields()) {
            if (!f.getName().equals(property)) continue;
            return f;
        }
        Class<?> parent = obj.getSuperclass();
        if (parent != null) {
            return BeanUtil.getField(property, parent);
        }
        return null;
    }
}

