/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.checker.impl.connector;

import java.util.Map;
import javax.annotation.Resource;
import org.dbsyncer.biz.BizException;
import org.dbsyncer.biz.checker.AbstractChecker;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Connector;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ConnectorChecker
extends AbstractChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private ConnectorFactory connectorFactory;

    @Override
    public ConfigModel checkAddConfigModel(Map<String, String> params) {
        this.printParams(params);
        String name = params.get("name");
        String connectorType = params.get("connectorType");
        Assert.hasText((String)name, (String)"connector name is empty.");
        Assert.hasText((String)connectorType, (String)"connector connectorType is empty.");
        Connector connector = new Connector();
        connector.setName(name);
        ConnectorConfig config = this.getConfig(connectorType);
        connector.setConfig(config);
        ConfigValidator configValidator = this.connectorFactory.getConnectorService(connectorType).getConfigValidator();
        Assert.notNull((Object)configValidator, (String)"ConfigValidator can not be null.");
        configValidator.modify((Object)config, params);
        ConnectorInstance connectorInstance = this.connectorFactory.connect(connector.getConfig());
        connector.setTable(this.connectorFactory.getTable(connectorInstance));
        this.modifyConfigModel((ConfigModel)connector, params);
        return connector;
    }

    @Override
    public ConfigModel checkEditConfigModel(Map<String, String> params) {
        this.printParams(params);
        Assert.notEmpty(params, (String)"ConnectorChecker check params is null.");
        String id = params.get("id");
        Connector connector = this.profileComponent.getConnector(id);
        Assert.notNull((Object)connector, (String)"Can not find connector.");
        ConnectorConfig config = connector.getConfig();
        this.connectorFactory.disconnect(config);
        this.modifyConfigModel((ConfigModel)connector, params);
        ConfigValidator configValidator = this.connectorFactory.getConnectorService(config.getConnectorType()).getConfigValidator();
        Assert.notNull((Object)configValidator, (String)"ConfigValidator can not be null.");
        configValidator.modify((Object)config, params);
        ConnectorInstance connectorInstance = this.connectorFactory.connect(config);
        connector.setTable(this.connectorFactory.getTable(connectorInstance));
        return connector;
    }

    private ConnectorConfig getConfig(String connectorType) {
        try {
            ConnectorService connectorService = this.connectorFactory.getConnectorService(connectorType);
            Class configClass = connectorService.getConfigClass();
            ConnectorConfig config = (ConnectorConfig)configClass.newInstance();
            config.setConnectorType(connectorService.getConnectorType());
            return config;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new BizException("\u83b7\u53d6\u8fde\u63a5\u5668\u914d\u7f6e\u5f02\u5e38.");
        }
    }
}

