/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.checker.impl.group;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.dbsyncer.biz.checker.AbstractChecker;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.ProjectGroup;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ProjectGroupChecker
extends AbstractChecker {
    @Resource
    private ProfileComponent profileComponent;

    @Override
    public ConfigModel checkAddConfigModel(Map<String, String> params) {
        String name = params.get("name");
        ProjectGroup projectGroup = new ProjectGroup();
        projectGroup.setName(name);
        this.modifyProjectGroup(projectGroup, params);
        this.modifyConfigModel((ConfigModel)projectGroup, params);
        return projectGroup;
    }

    @Override
    public ConfigModel checkEditConfigModel(Map<String, String> params) {
        String id = params.get("id");
        ProjectGroup projectGroup = this.profileComponent.getProjectGroup(id);
        Assert.notNull((Object)projectGroup, (String)"Can not find project group.");
        this.modifyProjectGroup(projectGroup, params);
        this.modifyConfigModel((ConfigModel)projectGroup, params);
        return projectGroup;
    }

    private void modifyProjectGroup(ProjectGroup projectGroup, Map<String, String> params) {
        Object[] connectorIds = StringUtil.split((String)params.get("connectorIds"), (String)"|");
        Object[] mappingIds = StringUtil.split((String)params.get("mappingIds"), (String)"|");
        boolean exist = (connectorIds != null && connectorIds.length > 0) | (mappingIds != null && mappingIds.length > 0);
        Assert.isTrue((boolean)exist, (String)"\u8bf7\u9009\u62e9\u8fde\u63a5\u6216\u9a71\u52a8.");
        projectGroup.setConnectorIds(CollectionUtils.isEmpty((Object[])connectorIds) ? Collections.EMPTY_LIST : Arrays.asList(connectorIds));
        projectGroup.setMappingIds(CollectionUtils.isEmpty((Object[])mappingIds) ? Collections.EMPTY_LIST : Arrays.asList(mappingIds));
    }
}

