/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.checker.impl.mapping;

import java.util.Map;
import org.dbsyncer.biz.checker.MappingConfigChecker;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.sdk.config.ListenerConfig;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class TimingConfigChecker
implements MappingConfigChecker {
    @Override
    public void modify(Mapping mapping, Map<String, String> params) {
        String cron = params.get("timingCronExpression");
        String eventFieldName = params.get("timingEventFieldName");
        String insert = params.get("timingInsert");
        String update = params.get("timingUpdate");
        String delete = params.get("timingDelete");
        ListenerConfig config = mapping.getListener();
        Assert.notNull((Object)config, (String)"ListenerConfig can not be null.");
        if (StringUtil.isNotBlank((CharSequence)cron)) {
            config.setCron(cron);
        }
        config.setEventFieldName(eventFieldName);
        if (StringUtil.isNotBlank((CharSequence)insert)) {
            config.setInsert(insert);
        }
        if (StringUtil.isNotBlank((CharSequence)update)) {
            config.setUpdate(update);
        }
        if (StringUtil.isNotBlank((CharSequence)delete)) {
            config.setDelete(delete);
        }
        config.setListenerType(ListenerTypeEnum.TIMING.getType());
        mapping.setListener(config);
    }
}

