/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.checker.impl.tablegroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbsyncer.biz.BizException;
import org.dbsyncer.biz.checker.AbstractChecker;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.ParserComponent;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.AbstractConfigModel;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.parser.util.PickerUtil;
import org.dbsyncer.sdk.enums.ModelEnum;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class TableGroupChecker
extends AbstractChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ParserComponent parserComponent;
    @Resource
    private ProfileComponent profileComponent;

    @Override
    public ConfigModel checkAddConfigModel(Map<String, String> params) {
        this.logger.info("params:{}", params);
        String mappingId = params.get("mappingId");
        String sourceTable = params.get("sourceTable");
        String targetTable = params.get("targetTable");
        String sourceTablePK = params.get("sourceTablePK");
        String targetTablePK = params.get("targetTablePK");
        Assert.hasText((String)mappingId, (String)"tableGroup mappingId is empty.");
        Assert.hasText((String)sourceTable, (String)"tableGroup sourceTable is empty.");
        Assert.hasText((String)targetTable, (String)"tableGroup targetTable is empty.");
        Mapping mapping = this.profileComponent.getMapping(mappingId);
        Assert.notNull((Object)mapping, (String)"mapping can not be null.");
        this.checkRepeatedTable(mappingId, sourceTable, targetTable);
        TableGroup tableGroup = new TableGroup();
        tableGroup.setMappingId(mappingId);
        tableGroup.setSourceTable(this.getTable(mapping.getSourceConnectorId(), sourceTable, sourceTablePK));
        tableGroup.setTargetTable(this.getTable(mapping.getTargetConnectorId(), targetTable, targetTablePK));
        this.modifyConfigModel((ConfigModel)tableGroup, params);
        this.matchSimilarFieldMapping(tableGroup);
        this.mergeConfig(mapping, tableGroup);
        return tableGroup;
    }

    @Override
    public ConfigModel checkEditConfigModel(Map<String, String> params) {
        this.logger.info("params:{}", params);
        Assert.notEmpty(params, (String)"TableGroupChecker check params is null.");
        String id = params.get("id");
        TableGroup tableGroup = this.profileComponent.getTableGroup(id);
        Assert.notNull((Object)tableGroup, (String)"Can not find tableGroup.");
        Mapping mapping = this.profileComponent.getMapping(tableGroup.getMappingId());
        Assert.notNull((Object)mapping, (String)"mapping can not be null.");
        String fieldMappingJson = params.get("fieldMapping");
        Assert.hasText((String)fieldMappingJson, (String)"TableGroupChecker check params fieldMapping is empty");
        this.modifyConfigModel((ConfigModel)tableGroup, params);
        this.modifySuperConfigModel((AbstractConfigModel)tableGroup, params);
        this.setFieldMapping(tableGroup, fieldMappingJson);
        this.mergeConfig(mapping, tableGroup);
        return tableGroup;
    }

    public void refreshTableFields(TableGroup tableGroup) {
        Mapping mapping = this.profileComponent.getMapping(tableGroup.getMappingId());
        Assert.notNull((Object)mapping, (String)"mapping can not be null.");
        Table sourceTable = tableGroup.getSourceTable();
        Table targetTable = tableGroup.getTargetTable();
        List sourceTablePks = sourceTable.getColumn().stream().filter(c -> c.isPk()).map(c -> c.getName()).collect(Collectors.toList());
        List targetTablePks = targetTable.getColumn().stream().filter(c -> c.isPk()).map(c -> c.getName()).collect(Collectors.toList());
        tableGroup.setSourceTable(this.getTable(mapping.getSourceConnectorId(), sourceTable.getName(), StringUtil.join(sourceTablePks, (String)",")));
        tableGroup.setTargetTable(this.getTable(mapping.getTargetConnectorId(), targetTable.getName(), StringUtil.join(targetTablePks, (String)",")));
    }

    public void mergeConfig(Mapping mapping, TableGroup tableGroup) {
        TableGroup group = PickerUtil.mergeTableGroupConfig((Mapping)mapping, (TableGroup)tableGroup);
        Map command = this.parserComponent.getCommand(mapping, group);
        tableGroup.setCommand(command);
        long count = ModelEnum.isFull((String)mapping.getModel()) && !CollectionUtils.isEmpty((Map)command) ? this.parserComponent.getCount(mapping.getSourceConnectorId(), command) : 0L;
        tableGroup.getSourceTable().setCount(count);
    }

    private Table getTable(String connectorId, String tableName, String primaryKeyStr) {
        MetaInfo metaInfo = this.parserComponent.getMetaInfo(connectorId, tableName);
        Assert.notNull((Object)metaInfo, (String)("\u65e0\u6cd5\u83b7\u53d6\u8fde\u63a5\u5668\u8868\u4fe1\u606f:" + tableName));
        if (StringUtil.isNotBlank((CharSequence)primaryKeyStr) && !CollectionUtils.isEmpty((Collection)metaInfo.getColumn())) {
            String[] pks = StringUtil.split((String)primaryKeyStr, (String)",");
            Arrays.asList(pks).stream().forEach(pk -> {
                for (Field field : metaInfo.getColumn()) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)field.getName(), (CharSequence)pk)) continue;
                    field.setPk(true);
                    break;
                }
            });
        }
        return new Table(tableName, metaInfo.getTableType(), metaInfo.getColumn(), metaInfo.getSql());
    }

    private void checkRepeatedTable(String mappingId, String sourceTable, String targetTable) {
        List list = this.profileComponent.getTableGroupAll(mappingId);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TableGroup g : list) {
                if (!StringUtil.equals((CharSequence)sourceTable, (CharSequence)g.getSourceTable().getName()) || !StringUtil.equals((CharSequence)targetTable, (CharSequence)g.getTargetTable().getName())) continue;
                String error = String.format("\u6620\u5c04\u5173\u7cfb\u5df2\u5b58\u5728.%s > %s", sourceTable, targetTable);
                this.logger.error(error);
                throw new BizException(error);
            }
        }
    }

    private void matchSimilarFieldMapping(TableGroup tableGroup) {
        List sCol = tableGroup.getSourceTable().getColumn();
        List tCol = tableGroup.getTargetTable().getColumn();
        if (CollectionUtils.isEmpty((Collection)sCol) || CollectionUtils.isEmpty((Collection)tCol)) {
            return;
        }
        HashMap<String, Field> m1 = new HashMap<String, Field>();
        HashMap<String, Field> m2 = new HashMap<String, Field>();
        LinkedHashSet<String> sourceFieldNames = new LinkedHashSet<String>();
        LinkedHashSet<String> targetFieldNames = new LinkedHashSet<String>();
        this.shuffleColumn(sCol, sourceFieldNames, m1);
        this.shuffleColumn(tCol, targetFieldNames, m2);
        AtomicBoolean existSourcePKFieldMapping = new AtomicBoolean();
        AtomicBoolean existTargetPKFieldMapping = new AtomicBoolean();
        sourceFieldNames.forEach(s -> {
            for (String t : targetFieldNames) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)s, (CharSequence)t)) continue;
                Field f1 = (Field)m1.get(s);
                Field f2 = (Field)m2.get(t);
                tableGroup.getFieldMapping().add(new FieldMapping(f1, f2));
                if (f1.isPk()) {
                    existSourcePKFieldMapping.set(true);
                }
                if (!f2.isPk()) break;
                existTargetPKFieldMapping.set(true);
                break;
            }
        });
        if (!existSourcePKFieldMapping.get() || !existTargetPKFieldMapping.get()) {
            List sourceTablePrimaryKeys = PrimaryKeyUtil.findTablePrimaryKeys((Table)tableGroup.getSourceTable());
            List targetTablePrimaryKeys = PrimaryKeyUtil.findTablePrimaryKeys((Table)tableGroup.getTargetTable());
            Assert.isTrue((!CollectionUtils.isEmpty((Collection)sourceTablePrimaryKeys) && !CollectionUtils.isEmpty((Collection)targetTablePrimaryKeys) ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u8868\u548c\u76ee\u6807\u6e90\u8868\u5fc5\u987b\u5305\u542b\u4e3b\u952e.");
            String sPK = (String)sourceTablePrimaryKeys.stream().findFirst().get();
            String tPK = (String)targetTablePrimaryKeys.stream().findFirst().get();
            tableGroup.getFieldMapping().add(new FieldMapping((Field)m1.get(sPK), (Field)m2.get(tPK)));
        }
    }

    private void shuffleColumn(List<Field> col, Set<String> key, Map<String, Field> map) {
        col.forEach(f -> {
            if (!key.contains(f.getName())) {
                key.add(f.getName());
                map.put(f.getName(), (Field)f);
            }
        });
    }

    private void setFieldMapping(TableGroup tableGroup, String json) {
        List mappings = JsonUtil.parseList((String)json);
        if (null == mappings) {
            throw new BizException("\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map sMap = PickerUtil.convert2Map((List)tableGroup.getSourceTable().getColumn());
        Map tMap = PickerUtil.convert2Map((List)tableGroup.getTargetTable().getColumn());
        int length = mappings.size();
        ArrayList<FieldMapping> list = new ArrayList<FieldMapping>();
        Map row = null;
        Field s = null;
        Field t = null;
        for (int i = 0; i < length; ++i) {
            row = (Map)mappings.get(i);
            s = (Field)sMap.get(row.get("source"));
            t = (Field)tMap.get(row.get("target"));
            if (null == s && null == t) continue;
            if (null != t) {
                t.setPk(((Boolean)row.get("pk")).booleanValue());
            }
            list.add(new FieldMapping(s, t));
        }
        tableGroup.setFieldMapping(list);
    }
}

