/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.dbsyncer.biz.DataSyncService;
import org.dbsyncer.biz.MonitorService;
import org.dbsyncer.biz.SystemConfigService;
import org.dbsyncer.biz.enums.BufferActuatorMetricEnum;
import org.dbsyncer.biz.enums.DiskMetricEnum;
import org.dbsyncer.biz.enums.MetricEnum;
import org.dbsyncer.biz.impl.BaseServiceImpl;
import org.dbsyncer.biz.impl.MetricReporter;
import org.dbsyncer.biz.metric.MetricDetailFormatter;
import org.dbsyncer.biz.metric.impl.CpuMetricDetailFormatter;
import org.dbsyncer.biz.metric.impl.DiskMetricDetailFormatter;
import org.dbsyncer.biz.metric.impl.DoubleRoundMetricDetailFormatter;
import org.dbsyncer.biz.metric.impl.GCMetricDetailFormatter;
import org.dbsyncer.biz.metric.impl.MemoryMetricDetailFormatter;
import org.dbsyncer.biz.metric.impl.ValueMetricDetailFormatter;
import org.dbsyncer.biz.model.AppReportMetric;
import org.dbsyncer.biz.model.MetricResponse;
import org.dbsyncer.biz.vo.AppReportMetricVo;
import org.dbsyncer.biz.vo.DataVo;
import org.dbsyncer.biz.vo.LogVo;
import org.dbsyncer.biz.vo.MetaVo;
import org.dbsyncer.biz.vo.MetricResponseVo;
import org.dbsyncer.common.model.Paging;
import org.dbsyncer.common.scheduled.ScheduledTaskJob;
import org.dbsyncer.common.scheduled.ScheduledTaskService;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.enums.MetaEnum;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.sdk.enums.FilterEnum;
import org.dbsyncer.sdk.enums.ModelEnum;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.filter.AbstractFilter;
import org.dbsyncer.sdk.filter.BooleanFilter;
import org.dbsyncer.sdk.filter.FieldResolver;
import org.dbsyncer.sdk.filter.Query;
import org.dbsyncer.sdk.filter.impl.LongFilter;
import org.dbsyncer.sdk.storage.StorageService;
import org.dbsyncer.storage.enums.StorageDataStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MonitorServiceImpl
extends BaseServiceImpl
implements MonitorService,
ScheduledTaskJob {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private MetricReporter metricReporter;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private DataSyncService dataSyncService;
    @Resource
    private ScheduledTaskService scheduledTaskService;
    @Resource
    private StorageService storageService;
    @Resource
    private LogService logService;
    @Resource
    private SystemConfigService systemConfigService;
    private Map<String, MetricDetailFormatter> metricDetailFormatterMap = new LinkedHashMap<String, MetricDetailFormatter>();

    @PostConstruct
    private void init() {
        this.metricDetailFormatterMap.putIfAbsent(BufferActuatorMetricEnum.GENERAL.getCode(), new ValueMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(BufferActuatorMetricEnum.STORAGE.getCode(), new ValueMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(BufferActuatorMetricEnum.TABLE_GROUP.getCode(), new ValueMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(MetricEnum.THREADS_LIVE.getCode(), new DoubleRoundMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(MetricEnum.THREADS_PEAK.getCode(), new DoubleRoundMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(MetricEnum.MEMORY_USED.getCode(), new MemoryMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(MetricEnum.MEMORY_COMMITTED.getCode(), new MemoryMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(MetricEnum.MEMORY_MAX.getCode(), new MemoryMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(MetricEnum.CPU_USAGE.getCode(), new CpuMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(MetricEnum.GC_PAUSE.getCode(), new GCMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(DiskMetricEnum.THRESHOLD.getCode(), new DiskMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(DiskMetricEnum.FREE.getCode(), new DiskMetricDetailFormatter());
        this.metricDetailFormatterMap.putIfAbsent(DiskMetricEnum.TOTAL.getCode(), new DiskMetricDetailFormatter());
        this.scheduledTaskService.start("0 */10 * * * ?", (ScheduledTaskJob)this);
    }

    @Override
    public List<MetaVo> getMetaAll() {
        List<MetaVo> list = this.profileComponent.getMetaAll().stream().map(m -> this.convertMeta2Vo((Meta)m)).sorted(Comparator.comparing(ConfigModel::getUpdateTime).reversed()).collect(Collectors.toList());
        return list;
    }

    @Override
    public MetaVo getMetaVo(String metaId) {
        Meta meta = this.profileComponent.getMeta(metaId);
        Assert.notNull((Object)meta, (String)"The meta is null.");
        return this.convertMeta2Vo(meta);
    }

    @Override
    public String getDefaultMetaId(Map<String, String> params) {
        String id = params.get("id");
        return this.getDefaultMetaId(id);
    }

    @Override
    public Paging queryData(Map<String, String> params) {
        String id = params.get("id");
        int pageNum = NumberUtil.toInt((String)params.get("pageNum"), (int)1);
        int pageSize = NumberUtil.toInt((String)params.get("pageSize"), (int)10);
        String error = params.get("error");
        String success = params.get("success");
        Paging paging = this.queryData(this.getDefaultMetaId(id), pageNum, pageSize, error, success);
        List data = (List)paging.getData();
        ArrayList<DataVo> list = new ArrayList<DataVo>();
        for (Map row : data) {
            try {
                DataVo dataVo = this.convert2Vo(row, DataVo.class);
                Map binlogData = this.dataSyncService.getBinlogData(row, true);
                dataVo.setJson(JsonUtil.objToJson((Object)binlogData));
                list.add(dataVo);
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        paging.setData(list);
        return paging;
    }

    @Override
    public String clearData(String id) {
        Assert.hasText((String)id, (String)"\u9a71\u52a8\u4e0d\u5b58\u5728.");
        Meta meta = this.profileComponent.getMeta(id);
        Mapping mapping = this.profileComponent.getMapping(meta.getMappingId());
        String model = ModelEnum.getModelEnum((String)mapping.getModel()).getName();
        LogType.MappingLog log = LogType.MappingLog.CLEAR_DATA;
        this.logService.log((LogType)log, "%s:%s(%s)", new Object[]{log.getMessage(), mapping.getName(), model});
        this.storageService.clear(StorageEnum.DATA, id);
        return "\u6e05\u7a7a\u540c\u6b65\u6570\u636e\u6210\u529f";
    }

    @Override
    public Paging queryLog(Map<String, String> params) {
        int pageNum = NumberUtil.toInt((String)params.get("pageNum"), (int)1);
        int pageSize = NumberUtil.toInt((String)params.get("pageSize"), (int)10);
        String json = params.get("json");
        Query query = new Query(pageNum, pageSize);
        if (StringUtil.isNotBlank((CharSequence)json)) {
            query.addFilter("json", json, true);
        }
        query.setType(StorageEnum.LOG);
        Paging paging = this.storageService.query(query);
        List data = (List)paging.getData();
        paging.setData((Collection)data.stream().map(m -> this.convert2Vo((Map)m, (Class)LogVo.class)).collect(Collectors.toList()));
        return paging;
    }

    @Override
    public String clearLog() {
        this.storageService.clear(StorageEnum.LOG, null);
        return "\u6e05\u7a7a\u65e5\u5fd7\u6210\u529f";
    }

    @Override
    public void deleteExpiredDataAndLog() {
        this.deleteExpiredData();
        this.deleteExpiredLog();
    }

    @Override
    public List<StorageDataStatusEnum> getStorageDataStatusEnumAll() {
        return this.profileComponent.getStorageDataStatusEnumAll();
    }

    @Override
    public List<MetricEnum> getMetricEnumAll() {
        return Arrays.asList(MetricEnum.values());
    }

    @Override
    public AppReportMetricVo queryAppReportMetric(List<MetricResponse> metrics) {
        AppReportMetric appReportMetric = this.metricReporter.getAppReportMetric();
        AppReportMetricVo vo = new AppReportMetricVo();
        BeanUtils.copyProperties((Object)appReportMetric, (Object)vo);
        vo.setMetrics(this.getMetrics(metrics));
        return vo;
    }

    public void run() {
        List metaAll = this.profileComponent.getMetaAll();
        if (CollectionUtils.isEmpty((Collection)metaAll)) {
            return;
        }
        StringBuilder content = new StringBuilder();
        metaAll.forEach(meta -> {
            Mapping mapping;
            if (MetaEnum.isRunning((int)meta.getState()) && meta.getFail().get() > 0L && null != (mapping = this.profileComponent.getMapping(meta.getMappingId()))) {
                ModelEnum modelEnum = ModelEnum.getModelEnum((String)mapping.getModel());
                content.append("<p>");
                content.append(String.format("%s(%s) \u5931\u8d25:%s, \u6210\u529f:%s", mapping.getName(), modelEnum.getName(), meta.getFail(), meta.getSuccess()));
                if (ModelEnum.FULL == modelEnum) {
                    content.append(String.format(", \u603b\u6570:%s", meta.getTotal()));
                }
                content.append("<p>");
            }
        });
        String msg = content.toString();
        if (StringUtil.isNotBlank((CharSequence)msg)) {
            this.sendNotifyMessage("\u540c\u6b65\u5931\u8d25", msg);
        }
    }

    private Paging queryData(String metaId, int pageNum, int pageSize, String error, String success) {
        if (StringUtil.isBlank((CharSequence)metaId)) {
            return new Paging(pageNum, pageSize);
        }
        Query query = new Query(pageNum, pageSize);
        LinkedHashMap<String, FieldResolver> fieldResolvers = new LinkedHashMap<String, FieldResolver>();
        fieldResolvers.put("data", field -> field.binaryValue().bytes);
        query.setFieldResolverMap(fieldResolvers);
        if (StringUtil.isNotBlank((CharSequence)error)) {
            query.addFilter("error", error, true);
        }
        query.addFilter("success", StringUtil.isNotBlank((CharSequence)success) ? NumberUtil.toInt((String)success) : StorageDataStatusEnum.FAIL.getValue());
        query.setMetaId(metaId);
        query.setType(StorageEnum.DATA);
        return this.storageService.query(query);
    }

    private void deleteExpiredData() {
        List<MetaVo> metaAll = this.getMetaAll();
        if (!CollectionUtils.isEmpty(metaAll)) {
            Query query = new Query();
            query.setType(StorageEnum.DATA);
            int expireDataDays = this.systemConfigService.getSystemConfigVo().getExpireDataDays();
            long expiredTime = Timestamp.valueOf(LocalDateTime.now().minusDays(expireDataDays)).getTime();
            LongFilter expiredFilter = new LongFilter("createTime", FilterEnum.LT, expiredTime);
            query.setBooleanFilter(new BooleanFilter().add((AbstractFilter)expiredFilter));
            metaAll.forEach(metaVo -> {
                query.setMetaId(metaVo.getId());
                this.storageService.delete(query);
            });
        }
    }

    private void deleteExpiredLog() {
        Query query = new Query();
        query.setType(StorageEnum.LOG);
        int expireLogDays = this.systemConfigService.getSystemConfigVo().getExpireLogDays();
        long expiredTime = Timestamp.valueOf(LocalDateTime.now().minusDays(expireLogDays)).getTime();
        LongFilter expiredFilter = new LongFilter("createTime", FilterEnum.LT, expiredTime);
        query.setBooleanFilter(new BooleanFilter().add((AbstractFilter)expiredFilter));
        this.storageService.delete(query);
    }

    private MetaVo convertMeta2Vo(Meta meta) {
        Mapping mapping = this.profileComponent.getMapping(meta.getMappingId());
        Assert.notNull((Object)mapping, (String)"\u9a71\u52a8\u4e0d\u5b58\u5728.");
        ModelEnum modelEnum = ModelEnum.getModelEnum((String)mapping.getModel());
        MetaVo metaVo = new MetaVo(modelEnum.getName(), mapping.getName());
        metaVo.setMappingName(mapping.getName());
        BeanUtils.copyProperties((Object)meta, (Object)((Object)metaVo));
        return metaVo;
    }

    private <T> T convert2Vo(Map map, Class<T> clazz) {
        return (T)JsonUtil.jsonToObj((String)JsonUtil.objToJson((Object)map), clazz);
    }

    private String getDefaultMetaId(String id) {
        List<MetaVo> list;
        if (StringUtil.isBlank((CharSequence)id) && !CollectionUtils.isEmpty(list = this.getMetaAll())) {
            return list.get(0).getId();
        }
        return id;
    }

    private List<MetricResponseVo> getMetrics(List<MetricResponse> metrics) {
        List<MetricResponse> metricList = this.metricReporter.getMetricInfo();
        metrics.addAll(metricList);
        return metrics.stream().map(metric -> {
            MetricResponseVo vo = new MetricResponseVo();
            BeanUtils.copyProperties((Object)metric, (Object)vo);
            MetricDetailFormatter detailFormatter = this.metricDetailFormatterMap.get(vo.getCode());
            if (null != detailFormatter) {
                detailFormatter.format(vo);
            }
            return vo;
        }).collect(Collectors.toList());
    }
}

