/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbsyncer.biz.BizException;
import org.dbsyncer.biz.PluginService;
import org.dbsyncer.biz.vo.PluginVo;
import org.dbsyncer.common.enums.FileSuffixEnum;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.plugin.PluginFactory;
import org.dbsyncer.plugin.model.Plugin;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class PluginServiceImpl
implements PluginService {
    @Resource
    private PluginFactory pluginFactory;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private LogService logService;

    @Override
    public List<PluginVo> getPluginAll() {
        List pluginAll = this.pluginFactory.getPluginAll();
        ArrayList<PluginVo> vos = new ArrayList<PluginVo>();
        if (!CollectionUtils.isEmpty((Collection)pluginAll)) {
            Map<String, List<String>> pluginClassNameMap = this.getPluginClassNameMap();
            vos.addAll(pluginAll.stream().map(plugin -> {
                PluginVo vo = new PluginVo();
                BeanUtils.copyProperties((Object)plugin, (Object)((Object)vo));
                vo.setMappingName(StringUtil.join((Iterable)((Iterable)pluginClassNameMap.get(plugin.getClassName())), (String)"|"));
                return vo;
            }).collect(Collectors.toList()));
        }
        return vos;
    }

    @Override
    public String getPluginPath() {
        return this.pluginFactory.getPluginPath();
    }

    @Override
    public String getLibraryPath() {
        return this.pluginFactory.getLibraryPath();
    }

    @Override
    public void loadPlugins() {
        this.pluginFactory.loadPlugins();
        this.logService.log((LogType)LogType.PluginLog.UPDATE);
    }

    @Override
    public void checkFileSuffix(String filename) {
        Assert.hasText((String)filename, (String)"the plugin filename is null.");
        String suffix = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
        FileSuffixEnum fileSuffix = FileSuffixEnum.getFileSuffix((String)suffix);
        Assert.notNull((Object)fileSuffix, (String)"Illegal file suffix");
        if (FileSuffixEnum.JAR != fileSuffix) {
            String msg = String.format("\u4e0d\u6b63\u786e\u7684\u6587\u4ef6\u6269\u5c55\u540d \"%s\"\uff0c\u53ea\u652f\u6301 \"%s\" \u7684\u6587\u4ef6\u6269\u5c55\u540d\u3002", filename, FileSuffixEnum.JAR.getName());
            this.logService.log((LogType)LogType.PluginLog.CHECK_ERROR, msg);
            throw new BizException(msg);
        }
    }

    private Map<String, List<String>> getPluginClassNameMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List mappingAll = this.profileComponent.getMappingAll();
        if (CollectionUtils.isEmpty((Collection)mappingAll)) {
            return map;
        }
        block0: for (Mapping m : mappingAll) {
            Plugin plugin = m.getPlugin();
            if (null != plugin) {
                map.putIfAbsent(plugin.getClassName(), new ArrayList());
                ((List)map.get(plugin.getClassName())).add(m.getName());
                continue;
            }
            List tableGroupAll = this.profileComponent.getTableGroupAll(m.getId());
            if (CollectionUtils.isEmpty((Collection)tableGroupAll)) continue;
            for (TableGroup t : tableGroupAll) {
                Plugin p = t.getPlugin();
                if (null == p) continue;
                map.putIfAbsent(p.getClassName(), new ArrayList());
                ((List)map.get(p.getClassName())).add(m.getName());
                continue block0;
            }
        }
        return map;
    }
}

