/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbsyncer.biz.BizException;
import org.dbsyncer.biz.UserConfigService;
import org.dbsyncer.biz.checker.impl.user.UserConfigChecker;
import org.dbsyncer.biz.enums.UserRoleEnum;
import org.dbsyncer.biz.vo.UserInfoVo;
import org.dbsyncer.common.util.SHA1Util;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.UserConfig;
import org.dbsyncer.parser.model.UserInfo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class UserConfigServiceImpl
implements UserConfigService {
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "0DPiKuNIrrVmD8IUCuw1hQxNqZc=";
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private UserConfigChecker userConfigChecker;
    @Resource
    private LogService logService;

    @Override
    public synchronized String add(Map<String, String> params) {
        String username = params.get("username");
        Assert.hasText((String)username, (String)"The username is null.");
        String nickname = params.get("nickname");
        Assert.hasText((String)nickname, (String)"The nickname is null.");
        String password = params.get("password");
        Assert.hasText((String)password, (String)"The password is null.");
        String mail = params.get("mail");
        UserConfig userConfig = this.getUserConfig();
        UserInfo currentUser = userConfig.getUserInfo(params.get("currentUserName"));
        Assert.isTrue((null == currentUser || UserRoleEnum.isAdmin(currentUser.getRoleCode()) ? 1 : 0) != 0, (String)"No permission.");
        Assert.isNull((Object)userConfig.getUserInfo(username), (String)"\u7528\u6237\u5df2\u5b58\u5728\uff0c\u8bf7\u6362\u4e2a\u8d26\u53f7");
        userConfig.getUserInfoList().add(new UserInfo(username, nickname, SHA1Util.b64_sha1((String)password), UserRoleEnum.USER.getCode(), mail));
        this.logService.log((LogType)LogType.UserLog.INSERT, String.format("[%s]\u6dfb\u52a0[%s]\u8d26\u53f7\u6210\u529f", currentUser.getUsername(), username));
        return this.profileComponent.editConfigModel((ConfigModel)userConfig);
    }

    @Override
    public synchronized String edit(Map<String, String> params) {
        String username = params.get("username");
        Assert.hasText((String)username, (String)"The username is null.");
        String nickname = params.get("nickname");
        Assert.hasText((String)nickname, (String)"The nickname is null.");
        String newPwd = params.get("newPwd");
        String mail = params.get("mail");
        UserConfig userConfig = this.getUserConfig();
        UserInfo currentUser = userConfig.getUserInfo(params.get("currentUserName"));
        boolean admin = null != currentUser && UserRoleEnum.isAdmin(currentUser.getRoleCode());
        boolean self = null != currentUser && StringUtil.equals((CharSequence)currentUser.getUsername(), (CharSequence)username);
        Assert.isTrue((admin || self ? 1 : 0) != 0, (String)"No permission.");
        UserInfo updateUser = self ? currentUser : userConfig.getUserInfo(username);
        Assert.notNull((Object)updateUser, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        updateUser.setNickname(nickname);
        updateUser.setMail(mail);
        if (StringUtil.isNotBlank((CharSequence)newPwd)) {
            if (self) {
                String oldPwd = params.get("oldPwd");
                Assert.hasText((String)oldPwd, (String)"\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a.");
                if (!StringUtil.equals((CharSequence)SHA1Util.b64_sha1((String)oldPwd), (CharSequence)updateUser.getPassword())) {
                    this.logService.log((LogType)LogType.SystemLog.ERROR, String.format("[%s]\u4fee\u6539\u5bc6\u7801\u5931\u8d25", username));
                    throw new BizException("\u4fee\u6539\u5bc6\u7801\u5931\u8d25.");
                }
            }
            Assert.isTrue((!StringUtil.equals((CharSequence)(newPwd = SHA1Util.b64_sha1((String)newPwd)), (CharSequence)updateUser.getPassword()) ? 1 : 0) != 0, (String)"\u65b0\u65e7\u5bc6\u7801\u4e0d\u80fd\u5b8c\u5168\u4e00\u6837.");
            updateUser.setPassword(newPwd);
            this.logService.log((LogType)LogType.UserLog.UPDATE, String.format("[%s]\u4fee\u6539[%s]\u8d26\u53f7\u5bc6\u7801\u6210\u529f", currentUser.getUsername(), username));
        }
        return this.profileComponent.editConfigModel((ConfigModel)userConfig);
    }

    @Override
    public synchronized String remove(Map<String, String> params) {
        String username = params.get("username");
        Assert.hasText((String)username, (String)"The username is null.");
        UserConfig userConfig = this.getUserConfig();
        UserInfo currentUser = userConfig.getUserInfo(params.get("currentUserName"));
        Assert.isTrue((boolean)UserRoleEnum.isAdmin(currentUser.getRoleCode()), (String)"No permission.");
        Assert.isTrue((!StringUtil.equals((CharSequence)currentUser.getUsername(), (CharSequence)username) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u5220\u9664\u81ea\u5df1.");
        UserInfo deleteUser = userConfig.getUserInfo(username);
        Assert.notNull((Object)deleteUser, (String)"\u7528\u6237\u5df2\u5220\u9664.");
        userConfig.removeUserInfo(username);
        this.profileComponent.editConfigModel((ConfigModel)userConfig);
        this.logService.log((LogType)LogType.UserLog.DELETE, String.format("[%s]\u5220\u9664[%s]\u8d26\u53f7\u6210\u529f", currentUser.getUsername(), username));
        return "\u5220\u9664\u7528\u6237\u6210\u529f!";
    }

    @Override
    public UserInfo getUserInfo(String currentUserName) {
        return this.getUserConfig().getUserInfo(currentUserName);
    }

    @Override
    public UserInfoVo getUserInfoVo(String currentUserName, String username) {
        UserConfig userConfig = this.getUserConfig();
        UserInfo currentUser = userConfig.getUserInfo(currentUserName);
        boolean admin = null != currentUser && UserRoleEnum.isAdmin(currentUser.getRoleCode());
        boolean self = null != currentUser && StringUtil.equals((CharSequence)currentUser.getUsername(), (CharSequence)username);
        Assert.isTrue((admin || self ? 1 : 0) != 0, (String)"No permission.");
        UserInfo userInfo = this.getUserConfig().getUserInfo(username);
        return this.convertUserInfo2Vo(userInfo);
    }

    @Override
    public List<UserInfoVo> getUserInfoAll(String currentUserName) {
        boolean admin;
        UserConfig userConfig = this.getUserConfig();
        UserInfo currentUser = userConfig.getUserInfo(currentUserName);
        boolean bl = admin = null != currentUser && UserRoleEnum.isAdmin(currentUser.getRoleCode());
        if (admin) {
            return this.getUserConfig().getUserInfoList().stream().map(user -> this.convertUserInfo2Vo((UserInfo)user)).collect(Collectors.toList());
        }
        ArrayList<UserInfoVo> list = new ArrayList<UserInfoVo>();
        UserInfo userInfo = userConfig.getUserInfo(currentUserName);
        list.add(this.convertUserInfo2Vo(userInfo));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserConfig getUserConfig() {
        UserConfig config = this.profileComponent.getUserConfig();
        if (null != config) {
            return config;
        }
        UserConfigServiceImpl userConfigServiceImpl = this;
        synchronized (userConfigServiceImpl) {
            config = this.profileComponent.getUserConfig();
            if (null == config) {
                config = (UserConfig)this.userConfigChecker.checkAddConfigModel(new HashMap<String, String>());
                UserRoleEnum admin = UserRoleEnum.ADMIN;
                config.getUserInfoList().add(new UserInfo(DEFAULT_USERNAME, DEFAULT_USERNAME, DEFAULT_PASSWORD, admin.getCode(), ""));
                this.profileComponent.addConfigModel((ConfigModel)config);
            }
            return config;
        }
    }

    private UserInfoVo convertUserInfo2Vo(UserInfo userInfo) {
        UserInfoVo userInfoVo = new UserInfoVo();
        if (null != userInfo) {
            BeanUtils.copyProperties((Object)userInfo, (Object)((Object)userInfoVo));
            userInfoVo.setPassword("***");
            userInfoVo.setRoleName(UserRoleEnum.getNameByCode(userInfo.getRoleCode()));
        }
        return userInfoVo;
    }
}

