/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Field;

class FieldReaderInt32ValueField<T>
extends FieldReaderObjectField<T> {
    final long fieldOffset;

    FieldReaderInt32ValueField(String fieldName, Class fieldType, int ordinal, String format, Integer defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, 0L, format, defaultValue, schema, field);
        this.fieldOffset = JDKUtils.UNSAFE_SUPPORT ? UnsafeUtils.objectFieldOffset(field) : 0L;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        int fieldInt = jsonReader.readInt32Value();
        if (this.schema != null) {
            this.schema.assertValidate((long)fieldInt);
        }
        if (JDKUtils.UNSAFE_SUPPORT) {
            UnsafeUtils.UNSAFE.putInt(object, this.fieldOffset, fieldInt);
        } else {
            try {
                this.field.setInt(object, fieldInt);
            }
            catch (Exception e) {
                throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
            }
        }
    }

    @Override
    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        int fieldInt = jsonReader.readInt32Value();
        this.accept(object, fieldInt);
    }

    @Override
    public void accept(T object, float value) {
        this.accept(object, (Object)((int)value));
    }

    @Override
    public void accept(T object, double value) {
        this.accept(object, (Object)((int)value));
    }

    @Override
    public void accept(T object, Object value) {
        int intValue = TypeUtils.toIntValue(value);
        if (this.schema != null) {
            this.schema.assertValidate((long)intValue);
        }
        if (JDKUtils.UNSAFE_SUPPORT) {
            UnsafeUtils.UNSAFE.putInt(object, this.fieldOffset, intValue);
        } else {
            try {
                this.field.setInt(object, intValue);
            }
            catch (Exception e) {
                throw new JSONException("set " + this.fieldName + " error", e);
            }
        }
    }

    @Override
    public void accept(T object, long value) {
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        int intValue = (int)value;
        if (JDKUtils.UNSAFE_SUPPORT) {
            UnsafeUtils.UNSAFE.putInt(object, this.fieldOffset, intValue);
        } else {
            try {
                this.field.setInt(object, intValue);
            }
            catch (Exception e) {
                throw new JSONException("set " + this.fieldName + " error", e);
            }
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readInt32Value();
    }
}

