/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObject;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class FieldReaderList<T, V>
extends FieldReaderObject<T> {
    final long fieldClassHash;
    final long itemClassHash;

    public FieldReaderList(String fieldName, Type fieldType, Class fieldClass, Type itemType, Class itemClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Method method, Field field, BiConsumer function) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, field, function);
        this.itemType = itemType;
        this.itemClass = itemClass;
        this.itemClassHash = this.itemClass == null ? 0L : Fnv.hashCode64(itemClass.getName());
        long l = this.fieldClassHash = fieldClass == null ? 0L : Fnv.hashCode64(TypeUtils.getTypeName(fieldClass));
        if (format != null && itemType == Date.class) {
            this.itemReader = new ObjectReaderImplDate(format, locale);
        }
    }

    @Override
    public long getItemClassHash() {
        return this.itemClassHash;
    }

    public Collection<V> createList(JSONReader.Context context) {
        if (this.fieldClass == List.class || this.fieldClass == Collection.class || this.fieldClass == ArrayList.class) {
            return new ArrayList();
        }
        return (Collection)this.getObjectReader(context).createInstance();
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (jsonReader.nextIfNull()) {
            this.accept(object, null);
            return;
        }
        JSONReader.Context context = jsonReader.getContext();
        ObjectReader objectReader = this.getObjectReader(context);
        Function builder = null;
        if (this.initReader != null) {
            builder = this.initReader.getBuildFunction();
        } else if (objectReader instanceof ObjectReaderImplList) {
            builder = objectReader.getBuildFunction();
        }
        if (jsonReader.isJSONB()) {
            ObjectReader autoTypeReader;
            long typeHash;
            Class fieldClass = this.fieldClass;
            if (jsonReader.nextIfMatch((byte)-110) && (typeHash = jsonReader.readTypeHashCode()) != this.fieldClassHash && jsonReader.isSupportAutoType(this.features)) {
                autoTypeReader = context.getObjectReaderAutoType(typeHash);
                if (autoTypeReader == null) {
                    String typeName = jsonReader.getString();
                    autoTypeReader = context.getObjectReaderAutoType(typeName, fieldClass, this.fieldClassHash);
                }
                objectReader = autoTypeReader;
                builder = autoTypeReader.getBuildFunction();
            }
            if (jsonReader.isReference()) {
                String reference = jsonReader.readReference();
                if ("..".equals(reference)) {
                    this.accept(object, object);
                    return;
                }
                this.addResolveTask(jsonReader, object, reference);
                return;
            }
            int entryCnt = jsonReader.startArray();
            Object[] array = new Object[entryCnt];
            ObjectReader itemObjectReader = this.getItemObjectReader(context);
            for (int i = 0; i < entryCnt; ++i) {
                autoTypeReader = jsonReader.checkAutoType(this.getItemClass(), this.getItemClassHash(), this.features);
                array[i] = autoTypeReader != null ? autoTypeReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, 0L) : itemObjectReader.readJSONBObject(jsonReader, this.fieldType, this.fieldName, 0L);
            }
            Collection list = (Collection)objectReader.createInstance(this.features);
            for (Object item : array) {
                list.add(item);
            }
            if (builder != null) {
                list = (Collection)builder.apply(list);
            }
            this.accept(object, list);
            return;
        }
        char current = jsonReader.current();
        if (current == '[') {
            JSONReader.Context ctx = context;
            ObjectReader itemObjectReader = this.getItemObjectReader(ctx);
            Collection list = this.createList(ctx);
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(itemObjectReader.readObject(jsonReader, null, null, 0L));
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            if (builder != null) {
                list = (Collection)builder.apply(list);
            }
            this.accept(object, list);
            jsonReader.nextIfMatch(',');
            return;
        }
        if (current == '{' && this.getItemObjectReader(context) instanceof ObjectReaderBean) {
            Object itemValue = jsonReader.isJSONB() ? this.itemReader.readJSONBObject(jsonReader, null, null, this.features) : this.itemReader.readObject(jsonReader, null, null, this.features);
            Collection list = (Collection)objectReader.createInstance(this.features);
            list.add(itemValue);
            if (builder != null) {
                list = (Collection)builder.apply(list);
            }
            this.accept(object, list);
            jsonReader.nextIfMatch(',');
            return;
        }
        Object value = jsonReader.isJSONB() ? objectReader.readJSONBObject(jsonReader, null, null, this.features) : objectReader.readObject(jsonReader, null, null, this.features);
        this.accept(object, value);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        if (jsonReader.isJSONB()) {
            int entryCnt = jsonReader.startArray();
            Object[] array = new Object[entryCnt];
            ObjectReader itemObjectReader = this.getItemObjectReader(jsonReader.getContext());
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = itemObjectReader.readObject(jsonReader, null, null, 0L);
            }
            return Arrays.asList(array);
        }
        if (jsonReader.current() == '[') {
            JSONReader.Context ctx = jsonReader.getContext();
            ObjectReader itemObjectReader = this.getItemObjectReader(ctx);
            Collection<V> list = this.createList(ctx);
            jsonReader.next();
            while (!jsonReader.nextIfMatch(']')) {
                list.add(itemObjectReader.readObject(jsonReader, null, null, 0L));
                if (!jsonReader.nextIfMatch(',')) continue;
            }
            jsonReader.nextIfMatch(',');
            return list;
        }
        if (jsonReader.isString()) {
            Function typeConvert;
            String str = jsonReader.readString();
            if (this.itemType instanceof Class && Number.class.isAssignableFrom((Class)this.itemType) && (typeConvert = jsonReader.getContext().getProvider().getTypeConvert((Type)((Object)String.class), this.itemType)) != null) {
                Collection<V> list = this.createList(jsonReader.getContext());
                if (str.indexOf(44) != -1) {
                    String[] items;
                    for (String item : items = str.split(",")) {
                        Object converted = typeConvert.apply(item);
                        list.add(converted);
                    }
                }
                return list;
            }
        }
        throw new JSONException(jsonReader.info("TODO : " + this.getClass()));
    }

    @Override
    public ObjectReader checkObjectAutoType(JSONReader jsonReader) {
        if (jsonReader.nextIfMatch((byte)-110)) {
            boolean isSupportAutoType;
            long typeHash = jsonReader.readTypeHashCode();
            long features = jsonReader.features(this.features);
            JSONReader.Context context = jsonReader.getContext();
            JSONReader.AutoTypeBeforeHandler autoTypeFilter = context.getContextAutoTypeBeforeHandler();
            if (autoTypeFilter != null) {
                Class<?> filterClass = autoTypeFilter.apply(typeHash, this.fieldClass, features);
                if (filterClass == null) {
                    String typeName = jsonReader.getString();
                    filterClass = autoTypeFilter.apply(typeName, this.fieldClass, features);
                }
                if (filterClass != null) {
                    return context.getObjectReader(this.fieldClass);
                }
            }
            if (!(isSupportAutoType = jsonReader.isSupportAutoType(features))) {
                throw new JSONException(jsonReader.info("autoType not support input " + jsonReader.getString()));
            }
            ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
            if (autoTypeObjectReader == null) {
                String typeName = jsonReader.getString();
                autoTypeObjectReader = context.getObjectReaderAutoType(typeName, this.fieldClass, features);
            }
            if (autoTypeObjectReader instanceof ObjectReaderImplList) {
                ObjectReaderImplList listReader = (ObjectReaderImplList)autoTypeObjectReader;
                autoTypeObjectReader = new ObjectReaderImplList(this.fieldType, this.fieldClass, listReader.instanceType, this.itemType, listReader.builder);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException(jsonReader.info("auotype not support : " + jsonReader.getString()));
            }
            return autoTypeObjectReader;
        }
        return null;
    }
}

