/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

final class ObjectReaderImplMapString
extends ObjectReaderImplMapTyped {
    public ObjectReaderImplMapString(Class mapType, Class instanceType, long features) {
        super(mapType, instanceType, null, (Type)((Object)String.class), features, null);
    }

    @Override
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        boolean match = jsonReader.nextIfMatch('{');
        if (!match) {
            if (jsonReader.current() == '[') {
                jsonReader.next();
                if (jsonReader.current() == '{') {
                    Object arrayItem = this.readObject(jsonReader, (Type)((Object)String.class), fieldName, features);
                    if (jsonReader.nextIfMatch(']')) {
                        jsonReader.nextIfMatch(',');
                        return arrayItem;
                    }
                }
                throw new JSONException(jsonReader.info("expect '{', but '['"));
            }
            if (jsonReader.nextIfNull()) {
                return null;
            }
        }
        JSONReader.Context context = jsonReader.getContext();
        HashMap<String, Object> object = this.instanceType == HashMap.class ? new HashMap<String, Object>() : (Map)this.createInstance(context.getFeatures() | features);
        long contextFeatures = features | context.getFeatures();
        int i = 0;
        while (!jsonReader.nextIfMatch('}')) {
            String origin;
            String name = jsonReader.readFieldName();
            String value = jsonReader.readString();
            if (!(i == 0 && (contextFeatures & JSONReader.Feature.SupportAutoType.mask) != 0L && name.equals(this.getTypeKey()) || (origin = object.put(name, value)) == null || (contextFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) == 0L)) {
                if (origin instanceof Collection) {
                    ((Collection)((Object)origin)).add(value);
                    object.put(name, value);
                } else {
                    JSONArray array = JSONArray.of((Object)origin, (Object)value);
                    object.put(name, array);
                }
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        return object;
    }
}

