/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.postgresql.decoder;

import java.nio.ByteBuffer;
import org.dbsyncer.connector.postgresql.column.PgColumnValue;
import org.dbsyncer.connector.postgresql.decoder.MessageDecoder;
import org.dbsyncer.connector.postgresql.enums.MessageTypeEnum;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.postgresql.replication.LogSequenceNumber;
import org.postgresql.util.PGmoney;

public abstract class AbstractMessageDecoder
implements MessageDecoder {
    protected String metaId;
    protected DatabaseConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean skipMessage(ByteBuffer buffer, LogSequenceNumber startLsn, LogSequenceNumber lastReceiveLsn) {
        if (null == lastReceiveLsn || lastReceiveLsn.asLong() == 0L || startLsn.equals((Object)lastReceiveLsn)) {
            return true;
        }
        int position = buffer.position();
        try {
            MessageTypeEnum type = MessageTypeEnum.getType((char)buffer.get());
            switch (type) {
                case BEGIN: 
                case COMMIT: 
                case RELATION: 
                case TRUNCATE: 
                case TYPE: 
                case ORIGIN: 
                case NONE: {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            buffer.position(position);
        }
    }

    @Override
    public String getSlotName() {
        return String.format("dbs_slot_%s_%s_%s", this.config.getSchema(), this.config.getUsername(), this.metaId).toLowerCase();
    }

    @Override
    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    @Override
    public void setConfig(DatabaseConfig config) {
        this.config = config;
    }

    protected Object resolveValue(String typeName, String columnValue) {
        PgColumnValue value = new PgColumnValue(columnValue);
        if (value.isNull()) {
            return null;
        }
        switch (typeName) {
            case "boolean": 
            case "bool": {
                return value.asBoolean();
            }
            case "integer": 
            case "int": 
            case "int4": 
            case "smallint": 
            case "int2": 
            case "smallserial": 
            case "serial": 
            case "serial2": 
            case "serial4": {
                return value.asInteger();
            }
            case "bigint": 
            case "bigserial": 
            case "int8": 
            case "oid": {
                return value.asLong();
            }
            case "real": 
            case "float4": {
                return value.asFloat();
            }
            case "double precision": 
            case "float8": {
                return value.asDouble();
            }
            case "numeric": 
            case "decimal": {
                return value.asBigDecimal();
            }
            case "character": 
            case "char": 
            case "character varying": 
            case "varchar": 
            case "bpchar": 
            case "text": 
            case "hstore": {
                return value.asString();
            }
            case "date": {
                return value.asDate();
            }
            case "timestamp with time zone": 
            case "timestamptz": {
                return value.asOffsetDateTimeAtUtc();
            }
            case "timestamp": 
            case "timestamp without time zone": {
                return value.asTimestamp();
            }
            case "time": {
                return value.asTime();
            }
            case "time without time zone": {
                return value.asLocalTime();
            }
            case "time with time zone": 
            case "timetz": {
                return value.asOffsetTimeUtc();
            }
            case "bytea": {
                return value.asByteArray();
            }
            case "box": {
                return value.asBox();
            }
            case "circle": {
                return value.asCircle();
            }
            case "interval": {
                return value.asInterval();
            }
            case "line": {
                return value.asLine();
            }
            case "lseg": {
                return value.asLseg();
            }
            case "money": {
                PGmoney v = value.asMoney();
                return v instanceof PGmoney ? Double.valueOf(v.val) : v;
            }
            case "path": {
                return value.asPath();
            }
            case "point": {
                return value.asPoint();
            }
            case "polygon": {
                return value.asPolygon();
            }
            case "geometry": 
            case "geography": 
            case "citext": 
            case "bit": 
            case "bit varying": 
            case "varbit": 
            case "json": 
            case "jsonb": 
            case "xml": 
            case "uuid": 
            case "tsrange": 
            case "tstzrange": 
            case "daterange": 
            case "inet": 
            case "cidr": 
            case "macaddr": 
            case "macaddr8": 
            case "int4range": 
            case "numrange": 
            case "int8range": {
                return value.asString();
            }
        }
        return null;
    }
}

