/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.postgresql.decoder.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.dbsyncer.common.column.Lexer;
import org.dbsyncer.connector.postgresql.decoder.AbstractMessageDecoder;
import org.dbsyncer.connector.postgresql.enums.MessageDecoderEnum;
import org.dbsyncer.connector.postgresql.enums.MessageTypeEnum;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDecodingMessageDecoder
extends AbstractMessageDecoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public RowChangedEvent processMessage(ByteBuffer buffer) {
        if (!buffer.hasArray()) {
            throw new IllegalStateException("Invalid buffer received from PG server during streaming replication");
        }
        MessageTypeEnum type = MessageTypeEnum.getType((char)buffer.get());
        if (MessageTypeEnum.TABLE == type) {
            int offset = buffer.arrayOffset();
            byte[] source = buffer.array();
            return this.parseMessage(new String(source, offset, source.length - offset));
        }
        return null;
    }

    @Override
    public String getOutputPlugin() {
        return MessageDecoderEnum.TEST_DECODING.getType();
    }

    @Override
    public void withSlotOption(ChainedLogicalStreamBuilder builder) {
        builder.withSlotOption("include-xids", true).withSlotOption("skip-empty-xacts", true);
    }

    private RowChangedEvent parseMessage(String message) {
        Lexer lexer = new Lexer(message);
        lexer.nextToken(' ');
        lexer.nextToken('.');
        lexer.skip(1);
        String table = lexer.nextToken('\"');
        lexer.skip(2);
        String eventType = lexer.nextToken(':');
        lexer.skip(1);
        ArrayList<Object> data = new ArrayList<Object>();
        while (lexer.hasNext()) {
            String name = this.parseName(lexer);
            if ("(no-tuple-data)".equals(name)) {
                return null;
            }
            String type = this.parseType(lexer);
            lexer.skip(1);
            String value = this.parseValue(lexer);
            data.add(this.resolveValue(type, value));
        }
        RowChangedEvent event = null;
        switch (eventType) {
            case "UPDATE": 
            case "INSERT": 
            case "DELETE": {
                event = new RowChangedEvent(table, eventType, data);
                break;
            }
            default: {
                this.logger.info("Type {} not implemented", (Object)eventType);
            }
        }
        return event;
    }

    private String parseName(Lexer lexer) {
        if (lexer.current() == ' ') {
            lexer.skip(1);
        }
        lexer.nextToken('[');
        return lexer.token();
    }

    private String parseType(Lexer lexer) {
        lexer.nextToken(']');
        return lexer.token();
    }

    private String parseValue(Lexer lexer) {
        if (lexer.current() == '\'') {
            lexer.skip(1);
            lexer.nextTokenToQuote();
            return lexer.token();
        }
        lexer.nextToken(' ');
        return lexer.token();
    }
}

