/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.slack;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.common.http.HttpProxy;
import org.elasticsearch.xpack.watcher.notification.slack.SentMessages;
import org.elasticsearch.xpack.watcher.notification.slack.message.SlackMessage;

public class SlackAction
implements Action {
    public static final String TYPE = "slack";
    final SlackMessage.Template message;
    @Nullable
    final String account;
    @Nullable
    final HttpProxy proxy;

    public SlackAction(@Nullable String account, SlackMessage.Template message, HttpProxy proxy) {
        this.account = account;
        this.message = message;
        this.proxy = proxy;
    }

    public String type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackAction that = (SlackAction)o;
        return Objects.equals(this.account, that.account) && Objects.equals(this.message, that.message) && Objects.equals(this.proxy, that.proxy);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.message, this.proxy);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.account != null) {
            builder.field(Field.ACCOUNT.getPreferredName(), this.account);
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, params);
        }
        builder.field(Field.MESSAGE.getPreferredName(), (ToXContent)this.message);
        return builder.endObject();
    }

    public static SlackAction parse(String watchId, String actionId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String account = null;
        SlackMessage.Template message = null;
        HttpProxy proxy = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.ACCOUNT.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    account = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. expected [{}] to be of type string, but found [{}] instead", new Object[]{TYPE, watchId, actionId, Field.ACCOUNT.getPreferredName(), token});
            }
            if (Field.PROXY.match(currentFieldName, parser.getDeprecationHandler())) {
                proxy = HttpProxy.parse(parser);
                continue;
            }
            if (Field.MESSAGE.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    message = SlackMessage.Template.parse(parser);
                    continue;
                }
                catch (Exception e) {
                    throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. failed to parse [{}] field", (Throwable)e, new Object[]{TYPE, watchId, actionId, Field.MESSAGE.getPreferredName()});
                }
            }
            throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. unexpected token [{}]", new Object[]{TYPE, watchId, actionId, token});
        }
        if (message == null) {
            throw new ElasticsearchParseException("failed to parse [{}] action [{}/{}]. missing required [{}] field", new Object[]{TYPE, watchId, actionId, Field.MESSAGE.getPreferredName()});
        }
        return new SlackAction(account, message, proxy);
    }

    public static Builder builder(String account, SlackMessage.Template message) {
        return new Builder(new SlackAction(account, message, null));
    }

    public static interface Field {
        public static final ParseField ACCOUNT = new ParseField("account", new String[0]);
        public static final ParseField MESSAGE = new ParseField("message", new String[0]);
        public static final ParseField PROXY = new ParseField("proxy", new String[0]);
    }

    public static class Builder
    implements Action.Builder<SlackAction> {
        final SlackAction action;

        public Builder(SlackAction action) {
            this.action = action;
        }

        public SlackAction build() {
            return this.action;
        }
    }

    public static interface Result {

        public static class Simulated
        extends Action.Result
        implements Result {
            private final SlackMessage message;

            protected Simulated(SlackMessage message) {
                super(SlackAction.TYPE, Action.Result.Status.SIMULATED);
                this.message = message;
            }

            public SlackMessage getMessage() {
                return this.message;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject(this.type).field(Field.MESSAGE.getPreferredName(), (ToXContent)this.message, params).endObject();
            }
        }

        public static class Executed
        extends Action.Result
        implements Result {
            private final SentMessages sentMessages;

            public Executed(SentMessages sentMessages) {
                super(SlackAction.TYPE, Executed.status(sentMessages));
                this.sentMessages = sentMessages;
            }

            public SentMessages sentMessages() {
                return this.sentMessages;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.field(this.type, (ToXContent)this.sentMessages, params);
            }

            static Action.Result.Status status(SentMessages sentMessages) {
                boolean hasSuccesses = false;
                boolean hasFailures = false;
                for (SentMessages.SentMessage message : sentMessages) {
                    if (message.isSuccess()) {
                        hasSuccesses = true;
                    } else {
                        hasFailures = true;
                    }
                    if (!hasFailures || !hasSuccesses) continue;
                    return Action.Result.Status.PARTIAL_FAILURE;
                }
                return hasFailures ? Action.Result.Status.FAILURE : Action.Result.Status.SUCCESS;
            }
        }
    }
}

