/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.toxcontent;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ANode;
import org.elasticsearch.painless.node.EAssignment;
import org.elasticsearch.painless.node.EBinary;
import org.elasticsearch.painless.node.EBooleanComp;
import org.elasticsearch.painless.node.EBooleanConstant;
import org.elasticsearch.painless.node.EBrace;
import org.elasticsearch.painless.node.ECall;
import org.elasticsearch.painless.node.ECallLocal;
import org.elasticsearch.painless.node.EComp;
import org.elasticsearch.painless.node.EConditional;
import org.elasticsearch.painless.node.EDecimal;
import org.elasticsearch.painless.node.EDot;
import org.elasticsearch.painless.node.EElvis;
import org.elasticsearch.painless.node.EExplicit;
import org.elasticsearch.painless.node.EFunctionRef;
import org.elasticsearch.painless.node.EInstanceof;
import org.elasticsearch.painless.node.ELambda;
import org.elasticsearch.painless.node.EListInit;
import org.elasticsearch.painless.node.EMapInit;
import org.elasticsearch.painless.node.ENewArray;
import org.elasticsearch.painless.node.ENewArrayFunctionRef;
import org.elasticsearch.painless.node.ENewObj;
import org.elasticsearch.painless.node.ENull;
import org.elasticsearch.painless.node.ENumeric;
import org.elasticsearch.painless.node.ERegex;
import org.elasticsearch.painless.node.EString;
import org.elasticsearch.painless.node.ESymbol;
import org.elasticsearch.painless.node.EUnary;
import org.elasticsearch.painless.node.SBlock;
import org.elasticsearch.painless.node.SBreak;
import org.elasticsearch.painless.node.SCatch;
import org.elasticsearch.painless.node.SClass;
import org.elasticsearch.painless.node.SContinue;
import org.elasticsearch.painless.node.SDeclBlock;
import org.elasticsearch.painless.node.SDeclaration;
import org.elasticsearch.painless.node.SDo;
import org.elasticsearch.painless.node.SEach;
import org.elasticsearch.painless.node.SExpression;
import org.elasticsearch.painless.node.SFor;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.node.SIf;
import org.elasticsearch.painless.node.SIfElse;
import org.elasticsearch.painless.node.SReturn;
import org.elasticsearch.painless.node.SThrow;
import org.elasticsearch.painless.node.STry;
import org.elasticsearch.painless.node.SWhile;
import org.elasticsearch.painless.phase.UserTreeBaseVisitor;
import org.elasticsearch.painless.symbol.Decorator;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.elasticsearch.painless.toxcontent.DecorationToXContent;
import org.elasticsearch.painless.toxcontent.XContentBuilderWrapper;

public class UserTreeToXContent
extends UserTreeBaseVisitor<ScriptScope> {
    public final XContentBuilderWrapper builder;

    public UserTreeToXContent(XContentBuilder builder) {
        this.builder = new XContentBuilderWrapper(Objects.requireNonNull(builder));
    }

    public UserTreeToXContent() {
        this.builder = new XContentBuilderWrapper();
    }

    @Override
    public void visitClass(SClass userClassNode, ScriptScope scope) {
        this.start(userClassNode);
        this.builder.field("source", scope.getScriptSource());
        this.builder.startArray("functions");
        userClassNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userClassNode, scope);
    }

    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scope) {
        this.start(userFunctionNode);
        this.builder.field("name", userFunctionNode.getFunctionName());
        this.builder.field("returns", userFunctionNode.getReturnCanonicalTypeName());
        if (!userFunctionNode.getParameterNames().isEmpty()) {
            this.builder.field("parameters", userFunctionNode.getParameterNames());
        }
        if (!userFunctionNode.getCanonicalTypeNameParameters().isEmpty()) {
            this.builder.field("parameterTypes", userFunctionNode.getCanonicalTypeNameParameters());
        }
        this.builder.field("isInternal", userFunctionNode.isInternal());
        this.builder.field("isStatic", userFunctionNode.isStatic());
        this.builder.field("isSynthetic", userFunctionNode.isSynthetic());
        this.builder.field("isAutoReturnEnabled", userFunctionNode.isAutoReturnEnabled());
        this.builder.startArray("block");
        userFunctionNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userFunctionNode, scope);
    }

    @Override
    public void visitBlock(SBlock userBlockNode, ScriptScope scope) {
        this.start(userBlockNode);
        this.builder.startArray("statements");
        userBlockNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userBlockNode, scope);
    }

    @Override
    public void visitIf(SIf userIfNode, ScriptScope scope) {
        this.start(userIfNode);
        this.builder.startArray("condition");
        userIfNode.getConditionNode().visit(this, scope);
        this.builder.endArray();
        this.block("ifBlock", userIfNode.getIfBlockNode(), scope);
        this.end(userIfNode, scope);
    }

    @Override
    public void visitIfElse(SIfElse userIfElseNode, ScriptScope scope) {
        this.start(userIfElseNode);
        this.builder.startArray("condition");
        userIfElseNode.getConditionNode().visit(this, scope);
        this.builder.endArray();
        this.block("ifBlock", userIfElseNode.getIfBlockNode(), scope);
        this.block("elseBlock", userIfElseNode.getElseBlockNode(), scope);
        this.end(userIfElseNode, scope);
    }

    @Override
    public void visitWhile(SWhile userWhileNode, ScriptScope scope) {
        this.start(userWhileNode);
        this.loop(userWhileNode.getConditionNode(), userWhileNode.getBlockNode(), scope);
        this.end(userWhileNode, scope);
    }

    @Override
    public void visitDo(SDo userDoNode, ScriptScope scope) {
        this.start(userDoNode);
        this.loop(userDoNode.getConditionNode(), userDoNode.getBlockNode(), scope);
        this.end(userDoNode, scope);
    }

    @Override
    public void visitFor(SFor userForNode, ScriptScope scope) {
        this.start(userForNode);
        ANode initializerNode = userForNode.getInitializerNode();
        this.builder.startArray("initializer");
        if (initializerNode != null) {
            initializerNode.visit(this, scope);
        }
        this.builder.endArray();
        this.builder.startArray("condition");
        AExpression conditionNode = userForNode.getConditionNode();
        if (conditionNode != null) {
            conditionNode.visit(this, scope);
        }
        this.builder.endArray();
        this.builder.startArray("afterthought");
        AExpression afterthoughtNode = userForNode.getAfterthoughtNode();
        if (afterthoughtNode != null) {
            afterthoughtNode.visit(this, scope);
        }
        this.builder.endArray();
        this.block(userForNode.getBlockNode(), scope);
        this.end(userForNode, scope);
    }

    @Override
    public void visitEach(SEach userEachNode, ScriptScope scope) {
        this.start(userEachNode);
        this.builder.field("type", userEachNode.getCanonicalTypeName());
        this.builder.field("symbol", userEachNode.getSymbol());
        this.builder.startArray("iterable");
        userEachNode.getIterableNode().visitChildren(this, scope);
        this.builder.endArray();
        this.block(userEachNode.getBlockNode(), scope);
        this.end(userEachNode, scope);
    }

    @Override
    public void visitDeclBlock(SDeclBlock userDeclBlockNode, ScriptScope scope) {
        this.start(userDeclBlockNode);
        this.builder.startArray("declarations");
        userDeclBlockNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userDeclBlockNode, scope);
    }

    @Override
    public void visitDeclaration(SDeclaration userDeclarationNode, ScriptScope scope) {
        this.start(userDeclarationNode);
        this.builder.field("type", userDeclarationNode.getCanonicalTypeName());
        this.builder.field("symbol", userDeclarationNode.getSymbol());
        this.builder.startArray("value");
        userDeclarationNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userDeclarationNode, scope);
    }

    @Override
    public void visitReturn(SReturn userReturnNode, ScriptScope scope) {
        this.start(userReturnNode);
        this.builder.startArray("value");
        userReturnNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userReturnNode, scope);
    }

    @Override
    public void visitExpression(SExpression userExpressionNode, ScriptScope scope) {
        this.start(userExpressionNode);
        this.builder.startArray("statement");
        userExpressionNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userExpressionNode, scope);
    }

    @Override
    public void visitTry(STry userTryNode, ScriptScope scope) {
        this.start(userTryNode);
        this.block(userTryNode.getBlockNode(), scope);
        this.builder.startArray("catch");
        for (SCatch catchNode : userTryNode.getCatchNodes()) {
            catchNode.visit(this, scope);
        }
        this.builder.endArray();
        this.end(userTryNode, scope);
    }

    @Override
    public void visitCatch(SCatch userCatchNode, ScriptScope scope) {
        this.start(userCatchNode);
        this.builder.field("exception", userCatchNode.getBaseException());
        this.builder.field("type", userCatchNode.getCanonicalTypeName());
        this.builder.field("symbol", userCatchNode.getSymbol());
        this.builder.startArray("block");
        userCatchNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userCatchNode, scope);
    }

    @Override
    public void visitThrow(SThrow userThrowNode, ScriptScope scope) {
        this.start(userThrowNode);
        this.builder.startArray("expression");
        userThrowNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userThrowNode, scope);
    }

    @Override
    public void visitContinue(SContinue userContinueNode, ScriptScope scope) {
        this.start(userContinueNode);
        this.end(userContinueNode, scope);
    }

    @Override
    public void visitBreak(SBreak userBreakNode, ScriptScope scope) {
        this.start(userBreakNode);
        this.end(userBreakNode, scope);
    }

    @Override
    public void visitAssignment(EAssignment userAssignmentNode, ScriptScope scope) {
        this.start(userAssignmentNode);
        this.builder.field("postIfRead", userAssignmentNode.postIfRead());
        this.binaryOperation(userAssignmentNode.getOperation(), userAssignmentNode.getLeftNode(), userAssignmentNode.getRightNode(), scope);
        this.end(userAssignmentNode, scope);
    }

    @Override
    public void visitUnary(EUnary userUnaryNode, ScriptScope scope) {
        this.start(userUnaryNode);
        this.operation(userUnaryNode.getOperation());
        this.builder.startArray("child");
        userUnaryNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userUnaryNode, scope);
    }

    @Override
    public void visitBinary(EBinary userBinaryNode, ScriptScope scope) {
        this.start(userBinaryNode);
        this.binaryOperation(userBinaryNode.getOperation(), userBinaryNode.getLeftNode(), userBinaryNode.getRightNode(), scope);
        this.end(userBinaryNode, scope);
    }

    @Override
    public void visitBooleanComp(EBooleanComp userBooleanCompNode, ScriptScope scope) {
        this.start(userBooleanCompNode);
        this.binaryOperation(userBooleanCompNode.getOperation(), userBooleanCompNode.getLeftNode(), userBooleanCompNode.getRightNode(), scope);
        this.end(userBooleanCompNode, scope);
    }

    @Override
    public void visitComp(EComp userCompNode, ScriptScope scope) {
        this.start(userCompNode);
        this.binaryOperation(userCompNode.getOperation(), userCompNode.getLeftNode(), userCompNode.getRightNode(), scope);
        this.end(userCompNode, scope);
    }

    @Override
    public void visitExplicit(EExplicit userExplicitNode, ScriptScope scope) {
        this.start(userExplicitNode);
        this.builder.field("type", userExplicitNode.getCanonicalTypeName());
        this.builder.startArray("child");
        userExplicitNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userExplicitNode, scope);
    }

    @Override
    public void visitInstanceof(EInstanceof userInstanceofNode, ScriptScope scope) {
        this.start(userInstanceofNode);
        this.builder.field("type", userInstanceofNode.getCanonicalTypeName());
        this.builder.startArray("child");
        userInstanceofNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userInstanceofNode, scope);
    }

    @Override
    public void visitConditional(EConditional userConditionalNode, ScriptScope scope) {
        this.start(userConditionalNode);
        this.builder.startArray("condition");
        userConditionalNode.getConditionNode().visit(this, scope);
        this.builder.endArray();
        this.builder.startArray("true");
        userConditionalNode.getTrueNode().visit(this, scope);
        this.builder.endArray();
        this.builder.startArray("false");
        userConditionalNode.getFalseNode().visit(this, scope);
        this.builder.endArray();
        this.end(userConditionalNode, scope);
    }

    @Override
    public void visitElvis(EElvis userElvisNode, ScriptScope scope) {
        this.start(userElvisNode);
        this.builder.startArray("left");
        userElvisNode.getLeftNode().visit(this, scope);
        this.builder.endArray();
        this.builder.startArray("right");
        userElvisNode.getRightNode().visit(this, scope);
        this.builder.endArray();
        this.end(userElvisNode, scope);
    }

    @Override
    public void visitListInit(EListInit userListInitNode, ScriptScope scope) {
        this.start(userListInitNode);
        this.builder.startArray("values");
        userListInitNode.visitChildren(this, scope);
        this.builder.endArray();
        this.end(userListInitNode, scope);
    }

    @Override
    public void visitMapInit(EMapInit userMapInitNode, ScriptScope scope) {
        this.start(userMapInitNode);
        this.expressions("keys", userMapInitNode.getKeyNodes(), scope);
        this.expressions("values", userMapInitNode.getValueNodes(), scope);
        this.end(userMapInitNode, scope);
    }

    @Override
    public void visitNewArray(ENewArray userNewArrayNode, ScriptScope scope) {
        this.start(userNewArrayNode);
        this.builder.field("type", userNewArrayNode.getCanonicalTypeName());
        this.builder.field("isInitializer", userNewArrayNode.isInitializer());
        this.expressions("values", userNewArrayNode.getValueNodes(), scope);
        this.end(userNewArrayNode, scope);
    }

    @Override
    public void visitNewObj(ENewObj userNewObjNode, ScriptScope scope) {
        this.start(userNewObjNode);
        this.builder.field("type", userNewObjNode.getCanonicalTypeName());
        this.arguments(userNewObjNode.getArgumentNodes(), scope);
        this.end(userNewObjNode, scope);
    }

    @Override
    public void visitCallLocal(ECallLocal userCallLocalNode, ScriptScope scope) {
        this.start(userCallLocalNode);
        this.builder.field("methodName", userCallLocalNode.getMethodName());
        this.arguments(userCallLocalNode.getArgumentNodes(), scope);
        this.end(userCallLocalNode, scope);
    }

    @Override
    public void visitBooleanConstant(EBooleanConstant userBooleanConstantNode, ScriptScope scope) {
        this.start(userBooleanConstantNode);
        this.builder.field("value", userBooleanConstantNode.getBool());
        this.end(userBooleanConstantNode, scope);
    }

    @Override
    public void visitNumeric(ENumeric userNumericNode, ScriptScope scope) {
        this.start(userNumericNode);
        this.builder.field("numeric", userNumericNode.getNumeric());
        this.builder.field("radix", userNumericNode.getRadix());
        this.end(userNumericNode, scope);
    }

    @Override
    public void visitDecimal(EDecimal userDecimalNode, ScriptScope scope) {
        this.start(userDecimalNode);
        this.builder.field("value", userDecimalNode.getDecimal());
        this.end(userDecimalNode, scope);
    }

    @Override
    public void visitString(EString userStringNode, ScriptScope scope) {
        this.start(userStringNode);
        this.builder.field("value", userStringNode.getString());
        this.end(userStringNode, scope);
    }

    @Override
    public void visitNull(ENull userNullNode, ScriptScope scope) {
        this.start(userNullNode);
        this.end(userNullNode, scope);
    }

    @Override
    public void visitRegex(ERegex userRegexNode, ScriptScope scope) {
        this.start(userRegexNode);
        this.builder.field("pattern", userRegexNode.getPattern());
        this.builder.field("flags", userRegexNode.getFlags());
        this.end(userRegexNode, scope);
    }

    @Override
    public void visitLambda(ELambda userLambdaNode, ScriptScope scope) {
        this.start(userLambdaNode);
        this.builder.field("types", userLambdaNode.getCanonicalTypeNameParameters());
        this.builder.field("parameters", userLambdaNode.getParameterNames());
        this.block(userLambdaNode.getBlockNode(), scope);
        this.end(userLambdaNode, scope);
    }

    @Override
    public void visitFunctionRef(EFunctionRef userFunctionRefNode, ScriptScope scope) {
        this.start(userFunctionRefNode);
        this.builder.field("symbol", userFunctionRefNode.getSymbol());
        this.builder.field("methodName", userFunctionRefNode.getMethodName());
        this.end(userFunctionRefNode, scope);
    }

    @Override
    public void visitNewArrayFunctionRef(ENewArrayFunctionRef userNewArrayFunctionRefNode, ScriptScope scope) {
        this.start(userNewArrayFunctionRefNode);
        this.builder.field("type", userNewArrayFunctionRefNode.getCanonicalTypeName());
        this.end(userNewArrayFunctionRefNode, scope);
    }

    @Override
    public void visitSymbol(ESymbol userSymbolNode, ScriptScope scope) {
        this.start(userSymbolNode);
        this.builder.field("symbol", userSymbolNode.getSymbol());
        this.end(userSymbolNode, scope);
    }

    @Override
    public void visitDot(EDot userDotNode, ScriptScope scope) {
        this.start(userDotNode);
        this.builder.startArray("prefix");
        userDotNode.visitChildren(this, scope);
        this.builder.endArray();
        this.builder.field("index", userDotNode.getIndex());
        this.builder.field("nullSafe", userDotNode.isNullSafe());
        this.end(userDotNode, scope);
    }

    @Override
    public void visitBrace(EBrace userBraceNode, ScriptScope scope) {
        this.start(userBraceNode);
        this.builder.startArray("prefix");
        userBraceNode.getPrefixNode().visit(this, scope);
        this.builder.endArray();
        this.builder.startArray("index");
        userBraceNode.getIndexNode().visit(this, scope);
        this.builder.endArray();
        this.end(userBraceNode, scope);
    }

    @Override
    public void visitCall(ECall userCallNode, ScriptScope scope) {
        this.start(userCallNode);
        this.builder.startArray("prefix");
        userCallNode.getPrefixNode().visitChildren(this, scope);
        this.builder.endArray();
        this.builder.field("isNullSafe", userCallNode.isNullSafe());
        this.builder.field("methodName", userCallNode.getMethodName());
        this.arguments(userCallNode.getArgumentNodes(), scope);
        this.end(userCallNode, scope);
    }

    private void start(ANode node) {
        this.builder.startObject();
        this.builder.field("node", node.getClass().getSimpleName());
        this.builder.field("location", node.getLocation().getOffset());
    }

    private void end(ANode node, ScriptScope scope) {
        this.decorations(node, scope);
        this.builder.endObject();
    }

    private void block(String name, SBlock block, ScriptScope scope) {
        this.builder.startArray(name);
        if (block != null) {
            block.visit(this, scope);
        }
        this.builder.endArray();
    }

    private void block(SBlock block, ScriptScope scope) {
        this.block("block", block, scope);
    }

    private void loop(AExpression condition, SBlock block, ScriptScope scope) {
        this.builder.startArray("condition");
        condition.visit(this, scope);
        this.builder.endArray();
        this.block(block, scope);
    }

    private void operation(Operation op) {
        this.builder.startObject("operation");
        if (op != null) {
            this.builder.field("symbol", op.symbol);
            this.builder.field("name", op.name);
        }
        this.builder.endObject();
    }

    private void binaryOperation(Operation op, AExpression left, AExpression right, ScriptScope scope) {
        this.operation(op);
        this.builder.startArray("left");
        left.visit(this, scope);
        this.builder.endArray();
        this.builder.startArray("right");
        right.visit(this, scope);
        this.builder.endArray();
    }

    private void arguments(List<AExpression> arguments, ScriptScope scope) {
        if (!arguments.isEmpty()) {
            this.expressions("arguments", arguments, scope);
        }
    }

    private void expressions(String name, List<AExpression> expressions, ScriptScope scope) {
        if (!expressions.isEmpty()) {
            this.builder.startArray(name);
            for (AExpression expression : expressions) {
                expression.visit(this, scope);
            }
            this.builder.endArray();
        }
    }

    private void decorations(ANode node, ScriptScope scope) {
        Map<Class<? extends Decorator.Decoration>, Decorator.Decoration> decorations;
        Set<Class<? extends Decorator.Condition>> conditions = scope.getAllConditions(node.getIdentifier());
        if (!conditions.isEmpty()) {
            this.builder.field("conditions", conditions.stream().map(Class::getSimpleName).sorted().collect(Collectors.toList()));
        }
        if (!(decorations = scope.getAllDecorations(node.getIdentifier())).isEmpty()) {
            this.builder.startArray("decorations");
            List dkeys = decorations.keySet().stream().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
            for (Class dkey : dkeys) {
                DecorationToXContent.ToXContent(decorations.get(dkey), this.builder);
            }
            this.builder.endArray();
        }
    }

    public String toString() {
        return this.builder.toString();
    }

    static final class Fields {
        static final String NODE = "node";
        static final String LOCATION = "location";
        static final String LEFT = "left";
        static final String RIGHT = "right";
        static final String BLOCK = "block";
        static final String CONDITION = "condition";
        static final String TYPE = "type";
        static final String SYMBOL = "symbol";
        static final String DECORATIONS = "decorations";
        static final String CONDITIONS = "conditions";

        Fields() {
        }
    }
}

