/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.saml.SamlToken;

public final class TransportSamlAuthenticateAction
extends HandledTransportAction<SamlAuthenticateRequest, SamlAuthenticateResponse> {
    private final ThreadPool threadPool;
    private final AuthenticationService authenticationService;
    private final TokenService tokenService;
    private final SecurityContext securityContext;

    @Inject
    public TransportSamlAuthenticateAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, AuthenticationService authenticationService, TokenService tokenService, SecurityContext securityContext) {
        super("cluster:admin/xpack/security/saml/authenticate", transportService, actionFilters, SamlAuthenticateRequest::new);
        this.threadPool = threadPool;
        this.authenticationService = authenticationService;
        this.tokenService = tokenService;
        this.securityContext = securityContext;
    }

    protected void doExecute(Task task, SamlAuthenticateRequest request, ActionListener<SamlAuthenticateResponse> listener) {
        SamlToken saml = new SamlToken(request.getSaml(), request.getValidRequestIds(), request.getRealm());
        this.logger.trace("Attempting to authenticate SamlToken [{}]", (Object)saml);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        Authentication originatingAuthentication = this.securityContext.getAuthentication();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            this.authenticationService.authenticate("cluster:admin/xpack/security/saml/authenticate", (TransportRequest)request, saml, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                AuthenticationResult result = (AuthenticationResult)threadContext.getTransient(AuthenticationResult.THREAD_CONTEXT_KEY);
                if (result == null) {
                    listener.onFailure((Exception)new IllegalStateException("Cannot find AuthenticationResult on thread context"));
                    return;
                }
                assert (authentication != null) : "authentication should never be null at this point";
                Map tokenMeta = (Map)result.getMetadata().get("_xpack_saml_tokendata");
                this.tokenService.createOAuth2Tokens((Authentication)authentication, originatingAuthentication, tokenMeta, true, (ActionListener<TokenService.CreateTokenResult>)ActionListener.wrap(tokenResult -> {
                    TimeValue expiresIn = this.tokenService.getExpirationDelay();
                    listener.onResponse((Object)new SamlAuthenticateResponse(authentication, tokenResult.getAccessToken(), tokenResult.getRefreshToken(), expiresIn));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }, e -> {
                this.logger.debug(() -> new ParameterizedMessage("SamlToken [{}] could not be authenticated", (Object)saml), (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }
}

