/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.service;

import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountRequest;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountResponse;
import org.elasticsearch.xpack.core.security.action.service.ServiceAccountInfo;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authc.support.HttpTlsRuntimeCheck;

public class TransportGetServiceAccountAction
extends HandledTransportAction<GetServiceAccountRequest, GetServiceAccountResponse> {
    private final HttpTlsRuntimeCheck httpTlsRuntimeCheck;

    @Inject
    public TransportGetServiceAccountAction(TransportService transportService, ActionFilters actionFilters, HttpTlsRuntimeCheck httpTlsRuntimeCheck) {
        super("cluster:admin/xpack/security/service_account/get", transportService, actionFilters, GetServiceAccountRequest::new);
        this.httpTlsRuntimeCheck = httpTlsRuntimeCheck;
    }

    protected void doExecute(Task task, GetServiceAccountRequest request, ActionListener<GetServiceAccountResponse> listener) {
        this.httpTlsRuntimeCheck.checkTlsThenExecute(arg_0 -> listener.onFailure(arg_0), "get service accounts", () -> {
            Predicate<ServiceAccount> filter = v -> true;
            if (request.getNamespace() != null) {
                filter = filter.and(v -> v.id().namespace().equals(request.getNamespace()));
            }
            if (request.getServiceName() != null) {
                filter = filter.and(v -> v.id().serviceName().equals(request.getServiceName()));
            }
            ServiceAccountInfo[] serviceAccountInfos = (ServiceAccountInfo[])ServiceAccountService.getServiceAccounts().values().stream().filter(filter).map(v -> new ServiceAccountInfo(v.id().asPrincipal(), v.roleDescriptor())).toArray(ServiceAccountInfo[]::new);
            listener.onResponse((Object)new GetServiceAccountResponse(serviceAccountInfos));
        });
    }
}

