/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.time.Clock;
import java.util.Collection;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.security.authc.saml.IdpConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SamlObjectHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlResponseHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.w3c.dom.Element;

public class SamlLogoutResponseHandler
extends SamlResponseHandler {
    private static final String LOGOUT_RESPONSE_TAG_NAME = "LogoutResponse";

    public SamlLogoutResponseHandler(Clock clock, IdpConfiguration idp, SpConfiguration sp, TimeValue maxSkew) {
        super(clock, idp, sp, maxSkew);
    }

    public void handle(boolean httpRedirect, String payload, Collection<String> allowedSamlRequestIds) {
        LogoutResponse logoutResponse;
        Element root;
        if (httpRedirect) {
            this.logger.debug("Process SAML LogoutResponse with HTTP-Redirect binding");
            SamlObjectHandler.ParsedQueryString parsed = this.parseQueryStringAndValidateSignature(payload, "SAMLResponse");
            if (!parsed.hasSignature) {
                throw SamlUtils.samlException("Query string is not signed, but is required for HTTP-Redirect binding", new Object[0]);
            }
            root = this.parseSamlMessage(this.inflate(this.decodeBase64(parsed.samlMessage)));
        } else {
            this.logger.debug("Process SAML LogoutResponse with HTTP-POST binding");
            root = this.parseSamlMessage(this.decodeBase64(payload));
        }
        if (LOGOUT_RESPONSE_TAG_NAME.equals(root.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:protocol".equals(root.getNamespaceURI())) {
            logoutResponse = this.buildXmlObject(root, LogoutResponse.class);
            if (!httpRedirect) {
                if (logoutResponse.getSignature() == null) {
                    throw SamlUtils.samlException("LogoutResponse is not signed, but is required for HTTP-Post binding", new Object[0]);
                }
                this.validateSignature(logoutResponse.getSignature());
            }
        } else {
            throw SamlUtils.samlException("SAML content [{}] should have a root element of Namespace=[{}] Tag=[{}]", root, "urn:oasis:names:tc:SAML:2.0:protocol", LOGOUT_RESPONSE_TAG_NAME);
        }
        this.checkInResponseTo((StatusResponseType)logoutResponse, allowedSamlRequestIds);
        this.checkStatus(logoutResponse.getStatus());
        this.checkIssuer(logoutResponse.getIssuer(), (XMLObject)logoutResponse);
        this.checkResponseDestination((StatusResponseType)logoutResponse, this.getSpConfiguration().getLogoutUrl());
    }
}

