/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.operator;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.transport.TransportRequest;

public class OperatorOnlyRegistry {
    public static final Set<String> SIMPLE_ACTIONS = org.elasticsearch.core.Set.of((Object[])new String[]{"cluster:admin/voting_config/add_exclusions", "cluster:admin/voting_config/clear_exclusions", "cluster:admin/xpack/license/put", "cluster:admin/xpack/license/delete", "cluster:admin/autoscaling/put_autoscaling_policy", "cluster:admin/autoscaling/delete_autoscaling_policy", "cluster:admin/repository/analyze", "cluster:admin/repository/analyze/blob", "cluster:admin/repository/analyze/blob/read", "cluster:admin/shutdown/create", "cluster:admin/shutdown/get", "cluster:admin/shutdown/delete"});
    private final ClusterSettings clusterSettings;

    public OperatorOnlyRegistry(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    public OperatorPrivilegesViolation check(String action, TransportRequest request) {
        if (SIMPLE_ACTIONS.contains(action)) {
            return () -> "action [" + action + "]";
        }
        if ("cluster:admin/settings/update".equals(action)) {
            assert (request instanceof ClusterUpdateSettingsRequest);
            return this.checkClusterUpdateSettings((ClusterUpdateSettingsRequest)request);
        }
        return null;
    }

    private OperatorPrivilegesViolation checkClusterUpdateSettings(ClusterUpdateSettingsRequest request) {
        List operatorOnlySettingKeys = Stream.concat(request.transientSettings().keySet().stream(), request.persistentSettings().keySet().stream()).filter(k -> {
            Setting setting = this.clusterSettings.get(k);
            return setting != null && setting.isOperatorOnly();
        }).collect(Collectors.toList());
        if (!operatorOnlySettingKeys.isEmpty()) {
            return () -> (operatorOnlySettingKeys.size() == 1 ? "setting" : "settings") + " [" + Strings.collectionToDelimitedString((Iterable)operatorOnlySettingKeys, (String)",") + "]";
        }
        return null;
    }

    @FunctionalInterface
    public static interface OperatorPrivilegesViolation {
        public String message();
    }
}

