/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.List;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;

public class TransportDeleteLifecycleAction
extends TransportMasterNodeAction<DeleteLifecycleAction.Request, AcknowledgedResponse> {
    @Inject
    public TransportDeleteLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ilm/delete", transportService, clusterService, threadPool, actionFilters, DeleteLifecycleAction.Request::new, indexNameExpressionResolver, AcknowledgedResponse::readFrom, "same");
    }

    protected void masterOperation(final DeleteLifecycleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("delete-lifecycle-" + request.getPolicyName(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                Spliterator indicesIt = currentState.metadata().indices().values().spliterator();
                String policyToDelete = request.getPolicyName();
                List indicesUsingPolicy = StreamSupport.stream(indicesIt, false).map(idxMeta -> (IndexMetadata)idxMeta.value).filter(idxMeta -> ((String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxMeta.getSettings())).equals(policyToDelete)).map(idxMeta -> idxMeta.getIndex().getName()).collect(Collectors.toList());
                if (!indicesUsingPolicy.isEmpty()) {
                    throw new IllegalArgumentException("Cannot delete policy [" + request.getPolicyName() + "]. It is in use by one or more indices: " + indicesUsingPolicy);
                }
                ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
                IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metadata().custom("index_lifecycle");
                if (currentMetadata == null || !currentMetadata.getPolicyMetadatas().containsKey(request.getPolicyName())) {
                    throw new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{request.getPolicyName()});
                }
                TreeMap newPolicies = new TreeMap(currentMetadata.getPolicyMetadatas());
                newPolicies.remove(request.getPolicyName());
                IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, currentMetadata.getOperationMode());
                newState.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("index_lifecycle", (Metadata.Custom)newMetadata).build());
                return newState.build();
            }
        });
    }

    protected ClusterBlockException checkBlock(DeleteLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

