/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequestBuilder;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.core.slm.SnapshotRetentionConfiguration;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryItem;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryStore;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;
import org.elasticsearch.xpack.slm.UpdateSnapshotLifecycleStatsTask;

public class SnapshotRetentionTask
implements SchedulerEngine.Listener {
    private static final Logger logger = LogManager.getLogger(SnapshotRetentionTask.class);
    private final Client client;
    private final ClusterService clusterService;
    private final LongSupplier nowNanoSupplier;
    private final SnapshotHistoryStore historyStore;
    private final Set<SnapshotId> runningDeletions = Collections.synchronizedSet(new HashSet());

    public SnapshotRetentionTask(Client client, ClusterService clusterService, LongSupplier nowNanoSupplier, SnapshotHistoryStore historyStore) {
        this.client = new OriginSettingClient(client, "index_lifecycle");
        this.clusterService = clusterService;
        this.nowNanoSupplier = nowNanoSupplier;
        this.historyStore = historyStore;
    }

    private static String formatSnapshots(Map<String, List<SnapshotInfo>> snapshotMap) {
        return snapshotMap.entrySet().stream().map(e -> (String)e.getKey() + ": [" + ((List)e.getValue()).stream().map(si -> si.snapshotId().getName()).collect(Collectors.joining(",")) + "]").collect(Collectors.joining(","));
    }

    public void triggered(SchedulerEngine.Event event) {
        assert (event.getJobName().equals("slm-retention-job") || event.getJobName().equals("slm-execute-manual-retention-job")) : "expected id to be slm-retention-job or slm-execute-manual-retention-job but it was " + event.getJobName();
        ClusterState state = this.clusterService.state();
        if (SnapshotLifecycleService.slmStoppedOrStopping(state) && !event.getJobName().equals("slm-execute-manual-retention-job")) {
            logger.debug("skipping SLM retention as SLM is currently stopped or stopping");
            return;
        }
        final SnapshotLifecycleStats slmStats = new SnapshotLifecycleStats();
        final Consumer<Exception> failureHandler = e -> {
            try {
                logger.error("error during snapshot retention task", (Throwable)e);
                slmStats.retentionFailed();
                this.updateStateWithStats(slmStats);
            }
            finally {
                logger.info("SLM retention snapshot cleanup task completed with error");
            }
        };
        try {
            logger.info("starting SLM retention snapshot cleanup task");
            slmStats.retentionRun();
            final Map<String, SnapshotLifecyclePolicy> policiesWithRetention = SnapshotRetentionTask.getAllPoliciesWithRetentionEnabled(state);
            logger.trace("policies with retention enabled: {}", policiesWithRetention.keySet());
            Set<String> repositioriesToFetch = policiesWithRetention.values().stream().map(SnapshotLifecyclePolicy::getRepository).collect(Collectors.toSet());
            logger.trace("fetching snapshots from repositories: {}", repositioriesToFetch);
            if (repositioriesToFetch.isEmpty()) {
                logger.info("there are no repositories to fetch, SLM retention snapshot cleanup task complete");
                return;
            }
            this.getAllRetainableSnapshots(repositioriesToFetch, new ActionListener<Map<String, List<SnapshotInfo>>>(){

                public void onResponse(Map<String, List<SnapshotInfo>> allSnapshots) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("retrieved snapshots: [{}]", (Object)SnapshotRetentionTask.formatSnapshots(allSnapshots));
                    }
                    Map<String, List<Tuple<SnapshotId, String>>> snapshotsToBeDeleted = allSnapshots.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().filter(snapshot -> SnapshotRetentionTask.snapshotEligibleForDeletion(snapshot, allSnapshots, policiesWithRetention)).map(snapshotInfo -> Tuple.tuple((Object)snapshotInfo.snapshotId(), (Object)SnapshotRetentionTask.getPolicyId(snapshotInfo))).collect(Collectors.toList())));
                    if (logger.isTraceEnabled()) {
                        logger.trace("snapshots eligible for deletion: [{}]", snapshotsToBeDeleted);
                    }
                    SnapshotRetentionTask.this.deleteSnapshots(snapshotsToBeDeleted, slmStats, (ActionListener<Void>)ActionListener.wrap(() -> {
                        SnapshotRetentionTask.this.updateStateWithStats(slmStats);
                        logger.info("SLM retention snapshot cleanup task complete");
                    }));
                }

                public void onFailure(Exception e) {
                    failureHandler.accept(e);
                }
            }, failureHandler);
        }
        catch (Exception e2) {
            failureHandler.accept(e2);
        }
    }

    static Map<String, SnapshotLifecyclePolicy> getAllPoliciesWithRetentionEnabled(ClusterState state) {
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        if (snapMeta == null) {
            return Collections.emptyMap();
        }
        return snapMeta.getSnapshotConfigurations().entrySet().stream().filter(e -> ((SnapshotLifecyclePolicyMetadata)e.getValue()).getPolicy().getRetentionPolicy() != null).filter(e -> !((SnapshotLifecyclePolicyMetadata)e.getValue()).getPolicy().getRetentionPolicy().equals((Object)SnapshotRetentionConfiguration.EMPTY)).collect(Collectors.toMap(Map.Entry::getKey, e -> ((SnapshotLifecyclePolicyMetadata)e.getValue()).getPolicy()));
    }

    static boolean snapshotEligibleForDeletion(SnapshotInfo snapshot, Map<String, List<SnapshotInfo>> allSnapshots, Map<String, SnapshotLifecyclePolicy> policies) {
        String policyId;
        if (snapshot.userMetadata() == null) {
            return false;
        }
        try {
            policyId = (String)snapshot.userMetadata().get("policy");
        }
        catch (Exception e) {
            logger.debug("unable to retrieve policy id from snapshot metadata [" + snapshot.userMetadata() + "]", (Throwable)e);
            return false;
        }
        if (policyId == null) {
            return false;
        }
        SnapshotLifecyclePolicy policy = policies.get(policyId);
        if (policy == null) {
            return false;
        }
        SnapshotRetentionConfiguration retention = policy.getRetentionPolicy();
        if (retention == null || retention.equals((Object)SnapshotRetentionConfiguration.EMPTY)) {
            return false;
        }
        String repository = policy.getRepository();
        boolean eligible = retention.getSnapshotDeletionPredicate(allSnapshots.get(repository).stream().filter(info -> Optional.ofNullable(info.userMetadata()).map(meta -> meta.get("policy")).map(pId -> pId.equals(policyId)).orElse(false)).collect(Collectors.toList())).test(snapshot);
        logger.debug("[{}] testing snapshot [{}] deletion eligibility: {}", (Object)repository, (Object)snapshot.snapshotId(), (Object)(eligible ? "ELIGIBLE" : "INELIGIBLE"));
        return eligible;
    }

    void getAllRetainableSnapshots(Collection<String> repositories, ActionListener<Map<String, List<SnapshotInfo>>> listener, Consumer<Exception> errorHandler) {
        if (repositories.isEmpty()) {
            listener.onResponse(Collections.emptyMap());
            return;
        }
        ((GetSnapshotsRequestBuilder)this.client.admin().cluster().prepareGetSnapshots(repositories.toArray(Strings.EMPTY_ARRAY)).setMasterNodeTimeout(TimeValue.MAX_VALUE)).setIgnoreUnavailable(true).execute(ActionListener.wrap(resp -> {
            if (logger.isTraceEnabled()) {
                logger.trace("retrieved snapshots: {}", repositories.stream().flatMap(repo -> resp.getSnapshots().stream().filter(info -> repo.equals(info.repository())).map(si -> si.snapshotId().getName())).collect(Collectors.toList()));
            }
            HashMap snapshots = new HashMap();
            Set retainableStates = org.elasticsearch.core.Set.of((Object[])new SnapshotState[]{SnapshotState.SUCCESS, SnapshotState.FAILED, SnapshotState.PARTIAL});
            repositories.forEach(repo -> snapshots.put(repo, resp.getSnapshots().stream().filter(info -> repo.equals(info.repository()) && retainableStates.contains(info.state())).collect(Collectors.toList())));
            listener.onResponse(snapshots);
        }, e -> {
            logger.debug((Message)new ParameterizedMessage("unable to retrieve snapshots for [{}] repositories", (Object)repositories), (Throwable)e);
            errorHandler.accept((Exception)e);
        }));
    }

    static String getPolicyId(SnapshotInfo snapshotInfo) {
        return Optional.ofNullable(snapshotInfo.userMetadata()).filter(meta -> meta.get("policy") != null).filter(meta -> meta.get("policy") instanceof String).map(meta -> (String)meta.get("policy")).orElseThrow(() -> new IllegalStateException("expected snapshot " + snapshotInfo + " to have a policy in its metadata, but it did not"));
    }

    void deleteSnapshots(Map<String, List<Tuple<SnapshotId, String>>> snapshotsToDelete, SnapshotLifecycleStats slmStats, ActionListener<Void> listener) {
        int count = snapshotsToDelete.values().stream().mapToInt(List::size).sum();
        if (count == 0) {
            listener.onResponse(null);
            logger.debug("no snapshots are eligible for deletion");
            return;
        }
        logger.info("starting snapshot retention deletion for [{}] snapshots", (Object)count);
        long startTime = this.nowNanoSupplier.getAsLong();
        AtomicInteger deleted = new AtomicInteger(0);
        AtomicInteger failed = new AtomicInteger(0);
        GroupedActionListener allDeletesListener = new GroupedActionListener(ActionListener.runAfter((ActionListener)listener.map(v -> null), () -> {
            TimeValue totalElapsedTime = TimeValue.timeValueNanos((long)(this.nowNanoSupplier.getAsLong() - startTime));
            logger.debug("total elapsed time for deletion of [{}] snapshots: {}", (Object)deleted, (Object)totalElapsedTime);
            slmStats.deletionTime(totalElapsedTime);
        }), snapshotsToDelete.size());
        for (Map.Entry<String, List<Tuple<SnapshotId, String>>> entry : snapshotsToDelete.entrySet()) {
            String repo = entry.getKey();
            List<Tuple<SnapshotId, String>> snapshots = entry.getValue();
            if (snapshots.isEmpty()) continue;
            this.deleteSnapshots(slmStats, deleted, failed, repo, snapshots, (ActionListener<Void>)allDeletesListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSnapshots(SnapshotLifecycleStats slmStats, AtomicInteger deleted, AtomicInteger failed, String repo, List<Tuple<SnapshotId, String>> snapshots, ActionListener<Void> listener) {
        GroupedActionListener allDeletesListener = new GroupedActionListener(listener.map(v -> null), snapshots.size());
        for (Tuple<SnapshotId, String> info : snapshots) {
            SnapshotId snapshotId = (SnapshotId)info.v1();
            if (!this.runningDeletions.add(snapshotId)) {
                allDeletesListener.onResponse(null);
                continue;
            }
            boolean success = false;
            try {
                String policyId = (String)info.v2();
                long deleteStartTime = this.nowNanoSupplier.getAsLong();
                this.deleteSnapshot(policyId, repo, snapshotId, slmStats, (ActionListener<AcknowledgedResponse>)ActionListener.runAfter((ActionListener)ActionListener.wrap(arg_0 -> this.lambda$deleteSnapshots$23(deleted, snapshotId, policyId, repo, (ActionListener)allDeletesListener, arg_0), arg_0 -> this.lambda$deleteSnapshots$24(failed, snapshotId, policyId, repo, (ActionListener)allDeletesListener, arg_0)), () -> {
                    this.runningDeletions.remove(snapshotId);
                    long finishTime = this.nowNanoSupplier.getAsLong();
                    TimeValue deletionTime = TimeValue.timeValueNanos((long)(finishTime - deleteStartTime));
                    logger.debug("elapsed time for deletion of [{}] snapshot: {}", (Object)snapshotId, (Object)deletionTime);
                }));
                success = true;
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            finally {
                if (success) continue;
                this.runningDeletions.remove(snapshotId);
            }
        }
    }

    void deleteSnapshot(String slmPolicy, String repo, SnapshotId snapshot, SnapshotLifecycleStats slmStats, ActionListener<AcknowledgedResponse> listener) {
        logger.info("[{}] snapshot retention deleting snapshot [{}]", (Object)repo, (Object)snapshot);
        ((DeleteSnapshotRequestBuilder)this.client.admin().cluster().prepareDeleteSnapshot(repo, new String[]{snapshot.getName()}).setMasterNodeTimeout(TimeValue.MAX_VALUE)).execute(ActionListener.wrap(acknowledgedResponse -> {
            slmStats.snapshotDeleted(slmPolicy);
            listener.onResponse(acknowledgedResponse);
        }, e -> {
            try {
                logger.warn((Message)new ParameterizedMessage("[{}] failed to delete snapshot [{}] for retention", (Object)repo, (Object)snapshot), (Throwable)e);
                slmStats.snapshotDeleteFailure(slmPolicy);
            }
            finally {
                listener.onFailure(e);
            }
        }));
    }

    void updateStateWithStats(SnapshotLifecycleStats newStats) {
        this.clusterService.submitStateUpdateTask("update_slm_stats", (ClusterStateTaskConfig)new UpdateSnapshotLifecycleStatsTask(newStats));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$deleteSnapshots$24(AtomicInteger failed, SnapshotId snapshotId, String policyId, String repo, ActionListener allDeletesListener, Exception e) {
        failed.incrementAndGet();
        try {
            SnapshotHistoryItem result = SnapshotHistoryItem.deletionFailureRecord((long)Instant.now().toEpochMilli(), (String)snapshotId.getName(), (String)policyId, (String)repo, (Exception)e);
            this.historyStore.putAsync(result);
        }
        catch (IOException ex) {
            logger.error((Message)new ParameterizedMessage("failed to record snapshot deletion failure for snapshot lifecycle policy [{}]", (Object)policyId), (Throwable)ex);
        }
        finally {
            allDeletesListener.onFailure(e);
        }
    }

    private /* synthetic */ void lambda$deleteSnapshots$23(AtomicInteger deleted, SnapshotId snapshotId, String policyId, String repo, ActionListener allDeletesListener, AcknowledgedResponse acknowledgedResponse) throws Exception {
        deleted.incrementAndGet();
        assert (acknowledgedResponse.isAcknowledged());
        this.historyStore.putAsync(SnapshotHistoryItem.deletionSuccessRecord((long)Instant.now().toEpochMilli(), (String)snapshotId.getName(), (String)policyId, (String)repo));
        allDeletesListener.onResponse(null);
    }
}

