/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.utils.VoidChainTaskExecutor;

public class MlConfigMigrator {
    private static final Logger logger = LogManager.getLogger(MlConfigMigrator.class);
    public static final String MIGRATED_FROM_VERSION = "migrated from version";
    static final int MAX_BULK_WRITE_SIZE = 100;
    private final Client client;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver expressionResolver;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;
    private final AtomicBoolean migrationInProgress;
    private final AtomicBoolean tookConfigSnapshot;

    public MlConfigMigrator(Settings settings, Client client, ClusterService clusterService, IndexNameExpressionResolver expressionResolver) {
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.expressionResolver = Objects.requireNonNull(expressionResolver);
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
        this.migrationInProgress = new AtomicBoolean(false);
        this.tookConfigSnapshot = new AtomicBoolean(false);
    }

    public void migrateConfigs(ClusterState clusterState, ActionListener<Boolean> listener) {
        if (!this.migrationInProgress.compareAndSet(false, true)) {
            listener.onResponse((Object)Boolean.FALSE);
            return;
        }
        ActionListener unMarkMigrationInProgress = ActionListener.wrap(response -> {
            this.migrationInProgress.set(false);
            listener.onResponse(response);
        }, e -> {
            this.migrationInProgress.set(false);
            listener.onFailure(e);
        });
        List<JobsAndDatafeeds> batches = MlConfigMigrator.splitInBatches(clusterState);
        if (batches.isEmpty()) {
            unMarkMigrationInProgress.onResponse((Object)Boolean.FALSE);
            return;
        }
        if (!clusterState.metadata().hasIndex(MlConfigIndex.indexName())) {
            this.createConfigIndex((ActionListener<Boolean>)ActionListener.wrap(response -> unMarkMigrationInProgress.onResponse((Object)Boolean.FALSE), arg_0 -> ((ActionListener)unMarkMigrationInProgress).onFailure(arg_0)));
            return;
        }
        if (!this.migrationEligibilityCheck.canStartMigration(clusterState)) {
            unMarkMigrationInProgress.onResponse((Object)Boolean.FALSE);
            return;
        }
        this.snapshotMlMeta(MlMetadata.getMlMetadata((ClusterState)clusterState), (ActionListener<Boolean>)ActionListener.wrap(response -> {
            this.tookConfigSnapshot.set(true);
            this.migrateBatches(batches, (ActionListener<Boolean>)unMarkMigrationInProgress);
        }, arg_0 -> ((ActionListener)unMarkMigrationInProgress).onFailure(arg_0)));
    }

    private void migrateBatches(List<JobsAndDatafeeds> batches, ActionListener<Boolean> listener) {
        VoidChainTaskExecutor voidChainTaskExecutor = new VoidChainTaskExecutor(EsExecutors.DIRECT_EXECUTOR_SERVICE, true);
        for (JobsAndDatafeeds batch : batches) {
            voidChainTaskExecutor.add(chainedListener -> this.writeConfigToIndex(batch.datafeedConfigs, batch.jobs, (ActionListener<Set<String>>)ActionListener.wrap(failedDocumentIds -> {
                List<Job> successfulJobWrites = MlConfigMigrator.filterFailedJobConfigWrites(failedDocumentIds, batch.jobs);
                List<DatafeedConfig> successfulDatafeedWrites = MlConfigMigrator.filterFailedDatafeedConfigWrites(failedDocumentIds, batch.datafeedConfigs);
                this.removeFromClusterState(successfulJobWrites, successfulDatafeedWrites, (ActionListener<Void>)chainedListener);
            }, arg_0 -> ((ActionListener)chainedListener).onFailure(arg_0))));
        }
        voidChainTaskExecutor.execute(ActionListener.wrap(aVoids -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)));
    }

    public void writeConfigToIndex(Collection<DatafeedConfig> datafeedsToMigrate, Collection<Job> jobsToMigrate, ActionListener<Set<String>> listener) {
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        this.addJobIndexRequests(jobsToMigrate, bulkRequestBuilder);
        this.addDatafeedIndexRequests(datafeedsToMigrate, bulkRequestBuilder);
        bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((BulkRequest)bulkRequestBuilder.request()), (ActionListener)ActionListener.wrap(bulkResponse -> {
            Set<String> failedDocumentIds = MlConfigMigrator.documentsNotWritten(bulkResponse);
            listener.onResponse(failedDocumentIds);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1));
    }

    private void removeFromClusterState(final List<Job> jobsToRemove, final List<DatafeedConfig> datafeedsToRemove, final ActionListener<Void> listener) {
        if (jobsToRemove.isEmpty() && datafeedsToRemove.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        final Map jobsMap = jobsToRemove.stream().collect(Collectors.toMap(Job::getId, Function.identity()));
        final Map datafeedMap = datafeedsToRemove.stream().collect(Collectors.toMap(DatafeedConfig::getId, Function.identity()));
        final AtomicReference removedConfigs = new AtomicReference();
        this.clusterService.submitStateUpdateTask("remove-migrated-ml-configs", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) {
                RemovalResult removed = MlConfigMigrator.removeJobsAndDatafeeds(jobsToRemove, datafeedsToRemove, MlMetadata.getMlMetadata((ClusterState)currentState));
                removedConfigs.set(removed);
                PersistentTasksCustomMetadata updatedTasks = MlConfigMigrator.rewritePersistentTaskParams(jobsMap, datafeedMap, (PersistentTasksCustomMetadata)currentState.metadata().custom("persistent_tasks"), currentState.nodes());
                ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
                Metadata.Builder metadataBuilder = Metadata.builder((Metadata)currentState.getMetadata()).putCustom("ml", (Metadata.Custom)removed.mlMetadata);
                if (updatedTasks != null) {
                    metadataBuilder = metadataBuilder.putCustom("persistent_tasks", (Metadata.Custom)updatedTasks);
                }
                newState.metadata(metadataBuilder.build());
                return newState.build();
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (removedConfigs.get() != null) {
                    if (!((RemovalResult)removedConfigs.get()).removedJobIds.isEmpty()) {
                        logger.info("ml job configurations migrated: {}", ((RemovalResult)removedConfigs.get()).removedJobIds);
                    }
                    if (!((RemovalResult)removedConfigs.get()).removedDatafeedIds.isEmpty()) {
                        logger.info("ml datafeed configurations migrated: {}", ((RemovalResult)removedConfigs.get()).removedDatafeedIds);
                    }
                }
                listener.onResponse(null);
            }
        });
    }

    public static PersistentTasksCustomMetadata rewritePersistentTaskParams(Map<String, Job> jobs, Map<String, DatafeedConfig> datafeeds, PersistentTasksCustomMetadata currentTasks, DiscoveryNodes nodes) {
        OpenJobAction.JobParams updatedParams;
        OpenJobAction.JobParams originalParams;
        Collection unallocatedJobTasks = MlTasks.unassignedJobTasks((PersistentTasksCustomMetadata)currentTasks, (DiscoveryNodes)nodes);
        Collection unallocatedDatafeedsTasks = MlTasks.unassignedDatafeedTasks((PersistentTasksCustomMetadata)currentTasks, (DiscoveryNodes)nodes);
        if (unallocatedJobTasks.isEmpty() && unallocatedDatafeedsTasks.isEmpty()) {
            return currentTasks;
        }
        PersistentTasksCustomMetadata.Builder taskBuilder = PersistentTasksCustomMetadata.builder((PersistentTasksCustomMetadata)currentTasks);
        for (PersistentTasksCustomMetadata.PersistentTask jobTask : unallocatedJobTasks) {
            originalParams = (OpenJobAction.JobParams)jobTask.getParams();
            if (originalParams.getJob() != null) continue;
            Job job = jobs.get(originalParams.getJobId());
            if (job != null) {
                logger.debug("updating persistent task params for job [{}]", (Object)originalParams.getJobId());
                updatedParams = new OpenJobAction.JobParams(originalParams.getJobId());
                updatedParams.setTimeout(originalParams.getTimeout());
                updatedParams.setJob(job);
                taskBuilder.removeTask(jobTask.getId());
                taskBuilder.addTask(jobTask.getId(), jobTask.getTaskName(), (PersistentTaskParams)updatedParams, jobTask.getAssignment());
                continue;
            }
            logger.error("cannot find job for task [{}]", (Object)jobTask.getId());
        }
        for (PersistentTasksCustomMetadata.PersistentTask datafeedTask : unallocatedDatafeedsTasks) {
            originalParams = (StartDatafeedAction.DatafeedParams)datafeedTask.getParams();
            if (originalParams.getJobId() != null) continue;
            DatafeedConfig datafeedConfig = datafeeds.get(originalParams.getDatafeedId());
            if (datafeedConfig != null) {
                logger.debug("Updating persistent task params for datafeed [{}]", (Object)originalParams.getDatafeedId());
                updatedParams = new StartDatafeedAction.DatafeedParams(originalParams.getDatafeedId(), originalParams.getStartTime());
                updatedParams.setTimeout(originalParams.getTimeout());
                updatedParams.setEndTime(originalParams.getEndTime());
                updatedParams.setJobId(datafeedConfig.getJobId());
                updatedParams.setDatafeedIndices(datafeedConfig.getIndices());
                taskBuilder.removeTask(datafeedTask.getId());
                taskBuilder.addTask(datafeedTask.getId(), datafeedTask.getTaskName(), (PersistentTaskParams)updatedParams, datafeedTask.getAssignment());
                continue;
            }
            logger.error("cannot find datafeed for task [{}]", (Object)datafeedTask.getId());
        }
        return taskBuilder.build();
    }

    static RemovalResult removeJobsAndDatafeeds(List<Job> jobsToRemove, List<DatafeedConfig> datafeedsToRemove, MlMetadata mlMetadata) {
        HashMap currentJobs = new HashMap(mlMetadata.getJobs());
        ArrayList<String> removedJobIds = new ArrayList<String>();
        for (Job job : jobsToRemove) {
            if (currentJobs.remove(job.getId()) == null) continue;
            removedJobIds.add(job.getId());
        }
        HashMap currentDatafeeds = new HashMap(mlMetadata.getDatafeeds());
        ArrayList<String> removedDatafeedIds = new ArrayList<String>();
        for (DatafeedConfig datafeed : datafeedsToRemove) {
            if (currentDatafeeds.remove(datafeed.getId()) == null) continue;
            removedDatafeedIds.add(datafeed.getId());
        }
        MlMetadata.Builder builder = new MlMetadata.Builder();
        builder.putJobs(currentJobs.values()).putDatafeeds(currentDatafeeds.values());
        return new RemovalResult(builder.build(), removedJobIds, removedDatafeedIds);
    }

    private void addJobIndexRequests(Collection<Job> jobs, BulkRequestBuilder bulkRequestBuilder) {
        ToXContent.MapParams params = new ToXContent.MapParams(JobConfigProvider.TO_XCONTENT_PARAMS);
        for (Job job : jobs) {
            logger.debug("adding job to migrate: " + job.getId());
            bulkRequestBuilder.add(this.indexRequest((ToXContentObject)job, Job.documentId((String)job.getId()), (ToXContent.Params)params));
        }
    }

    private void addDatafeedIndexRequests(Collection<DatafeedConfig> datafeedConfigs, BulkRequestBuilder bulkRequestBuilder) {
        ToXContent.MapParams params = new ToXContent.MapParams(DatafeedConfigProvider.TO_XCONTENT_PARAMS);
        for (DatafeedConfig datafeedConfig : datafeedConfigs) {
            logger.debug("adding datafeed to migrate: " + datafeedConfig.getId());
            bulkRequestBuilder.add(this.indexRequest((ToXContentObject)datafeedConfig, DatafeedConfig.documentId((String)datafeedConfig.getId()), (ToXContent.Params)params));
        }
    }

    private IndexRequest indexRequest(ToXContentObject source, String documentId, ToXContent.Params params) {
        IndexRequest indexRequest = new IndexRequest(MlConfigIndex.indexName()).id(documentId);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            indexRequest.source(source.toXContent(builder, params));
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to serialise object [" + documentId + "]", e);
        }
        return indexRequest;
    }

    public void snapshotMlMeta(MlMetadata mlMetadata, ActionListener<Boolean> listener) {
        if (this.tookConfigSnapshot.get()) {
            listener.onResponse((Object)true);
            return;
        }
        if (mlMetadata.getJobs().isEmpty() && mlMetadata.getDatafeeds().isEmpty()) {
            listener.onResponse((Object)true);
            return;
        }
        logger.debug("taking a snapshot of ml_metadata");
        String documentId = "ml-config";
        IndexRequest indexRequest = new IndexRequest(AnomalyDetectorsIndex.jobStateIndexWriteAlias()).id(documentId).setRequireAlias(true).opType(DocWriteRequest.OpType.CREATE);
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true"));
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            mlMetadata.toXContent(builder, (ToXContent.Params)params);
            builder.endObject();
            indexRequest.source(builder);
        }
        catch (IOException e) {
            logger.error("failed to serialise ml_metadata", (Throwable)e);
            listener.onFailure((Exception)e);
            return;
        }
        AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessary((Client)this.client, (ClusterState)this.clusterService.state(), (IndexNameExpressionResolver)this.expressionResolver, (TimeValue)MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT, (ActionListener)ActionListener.wrap(r -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(indexResponse -> listener.onResponse((Object)(indexResponse.getResult() == DocWriteResponse.Result.CREATED ? 1 : 0)), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException) {
                listener.onResponse((Object)Boolean.TRUE);
            } else {
                listener.onFailure(e);
            }
        }), (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1)), arg_0 -> listener.onFailure(arg_0)));
    }

    private void createConfigIndex(ActionListener<Boolean> listener) {
        logger.info("creating the .ml-config index");
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(MlConfigIndex.indexName());
        try {
            createIndexRequest.settings(MlConfigIndex.settings());
            createIndexRequest.mapping("_doc", MlConfigIndex.mapping(), XContentType.JSON);
            createIndexRequest.origin("ml");
        }
        catch (Exception e) {
            logger.error("error writing the .ml-config mappings", (Throwable)e);
            listener.onFailure(e);
            return;
        }
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)createIndexRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)r.isAcknowledged()), arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
    }

    public static Job updateJobForMigration(Job job) {
        Job.Builder builder = new Job.Builder(job);
        HashMap<String, String> custom = job.getCustomSettings() == null ? new HashMap<String, String>() : new HashMap(job.getCustomSettings());
        String version = job.getJobVersion() != null ? job.getJobVersion().toString() : null;
        custom.put(MIGRATED_FROM_VERSION, version);
        builder.setCustomSettings(custom);
        Version jobVersion = job.getJobVersion();
        if (jobVersion != null && jobVersion.onOrAfter(Version.V_6_1_0) && jobVersion.before(Version.V_6_3_0) && job.getAnalysisLimits() != null && job.getAnalysisLimits().getModelMemoryLimit() != null && job.getAnalysisLimits().getModelMemoryLimit() < 512L) {
            long updatedModelMemoryLimit = (long)((double)job.getAnalysisLimits().getModelMemoryLimit().longValue() * 1.3);
            AnalysisLimits limits = new AnalysisLimits(Long.valueOf(updatedModelMemoryLimit), job.getAnalysisLimits().getCategorizationExamplesLimit());
            builder.setAnalysisLimits(limits);
        }
        if (jobVersion != null) {
            builder.setJobVersion(Version.CURRENT);
        }
        return builder.build();
    }

    public static List<Job> nonDeletingJobs(List<Job> jobs) {
        return jobs.stream().filter(job -> !job.isDeleting()).collect(Collectors.toList());
    }

    public static List<Job> closedOrUnallocatedJobs(ClusterState clusterState) {
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.metadata().custom("persistent_tasks");
        Set openJobIds = MlTasks.openJobIds((PersistentTasksCustomMetadata)persistentTasks);
        openJobIds.removeAll(MlTasks.unassignedJobIds((PersistentTasksCustomMetadata)persistentTasks, (DiscoveryNodes)clusterState.nodes()));
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        return mlMetadata.getJobs().values().stream().filter(job -> !openJobIds.contains(job.getId())).collect(Collectors.toList());
    }

    public static List<DatafeedConfig> stoppedOrUnallocatedDatafeeds(ClusterState clusterState) {
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)clusterState.metadata().custom("persistent_tasks");
        Set startedDatafeedIds = MlTasks.startedDatafeedIds((PersistentTasksCustomMetadata)persistentTasks);
        startedDatafeedIds.removeAll(MlTasks.unassignedDatafeedIds((PersistentTasksCustomMetadata)persistentTasks, (DiscoveryNodes)clusterState.nodes()));
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        return mlMetadata.getDatafeeds().values().stream().filter(datafeedConfig -> !startedDatafeedIds.contains(datafeedConfig.getId())).collect(Collectors.toList());
    }

    public static List<JobsAndDatafeeds> splitInBatches(ClusterState clusterState) {
        List<DatafeedConfig> stoppedDatafeeds = MlConfigMigrator.stoppedOrUnallocatedDatafeeds(clusterState);
        Map<String, Job> eligibleJobs = MlConfigMigrator.nonDeletingJobs(MlConfigMigrator.closedOrUnallocatedJobs(clusterState)).stream().map(MlConfigMigrator::updateJobForMigration).collect(Collectors.toMap(Job::getId, Function.identity(), (a, b) -> a));
        ArrayList<JobsAndDatafeeds> batches = new ArrayList<JobsAndDatafeeds>();
        while (!stoppedDatafeeds.isEmpty() || !eligibleJobs.isEmpty()) {
            JobsAndDatafeeds batch = MlConfigMigrator.limitWrites(stoppedDatafeeds, eligibleJobs);
            batches.add(batch);
            stoppedDatafeeds.removeAll(batch.datafeedConfigs);
            batch.jobs.forEach(job -> eligibleJobs.remove(job.getId()));
        }
        return batches;
    }

    public static JobsAndDatafeeds limitWrites(Collection<DatafeedConfig> datafeedsToMigrate, Map<String, Job> jobsToMigrate) {
        JobsAndDatafeeds jobsAndDatafeeds = new JobsAndDatafeeds();
        if (datafeedsToMigrate.size() + jobsToMigrate.size() <= 100) {
            jobsAndDatafeeds.jobs.addAll(jobsToMigrate.values());
            jobsAndDatafeeds.datafeedConfigs.addAll(datafeedsToMigrate);
            return jobsAndDatafeeds;
        }
        int count = 0;
        for (DatafeedConfig datafeedConfig : datafeedsToMigrate) {
            if (count >= 100) continue;
            jobsAndDatafeeds.datafeedConfigs.add(datafeedConfig);
            ++count;
            Job datafeedsJob = jobsToMigrate.remove(datafeedConfig.getJobId());
            if (datafeedsJob == null) continue;
            jobsAndDatafeeds.jobs.add(datafeedsJob);
            ++count;
        }
        Iterator<Job> iter = jobsToMigrate.values().iterator();
        while (iter.hasNext() && count < 100) {
            jobsAndDatafeeds.jobs.add(iter.next());
            ++count;
        }
        return jobsAndDatafeeds;
    }

    static Set<String> documentsNotWritten(BulkResponse response) {
        HashSet<String> failedDocumentIds = new HashSet<String>();
        for (BulkItemResponse itemResponse : response.getItems()) {
            if (itemResponse.isFailed()) {
                BulkItemResponse.Failure failure = itemResponse.getFailure();
                failedDocumentIds.add(itemResponse.getFailure().getId());
                logger.info("failed to index ml configuration [" + itemResponse.getFailure().getId() + "], " + itemResponse.getFailure().getMessage());
                continue;
            }
            logger.info("ml configuration [" + itemResponse.getId() + "] indexed");
        }
        return failedDocumentIds;
    }

    static List<Job> filterFailedJobConfigWrites(Set<String> failedDocumentIds, List<Job> jobs) {
        return jobs.stream().filter(job -> !failedDocumentIds.contains(Job.documentId((String)job.getId()))).collect(Collectors.toList());
    }

    static List<DatafeedConfig> filterFailedDatafeedConfigWrites(Set<String> failedDocumentIds, Collection<DatafeedConfig> datafeeds) {
        return datafeeds.stream().filter(datafeed -> !failedDocumentIds.contains(DatafeedConfig.documentId((String)datafeed.getId()))).collect(Collectors.toList());
    }

    public static class JobsAndDatafeeds {
        List<Job> jobs = new ArrayList<Job>();
        List<DatafeedConfig> datafeedConfigs = new ArrayList<DatafeedConfig>();

        private JobsAndDatafeeds() {
        }

        public int totalCount() {
            return this.jobs.size() + this.datafeedConfigs.size();
        }
    }

    static class RemovalResult {
        MlMetadata mlMetadata;
        List<String> removedJobIds;
        List<String> removedDatafeedIds;

        RemovalResult(MlMetadata mlMetadata, List<String> removedJobIds, List<String> removedDatafeedIds) {
            this.mlMetadata = mlMetadata;
            this.removedJobIds = removedJobIds;
            this.removedDatafeedIds = removedDatafeedIds;
        }
    }
}

