/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractTransportGetResourcesAction;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;

public class TransportGetFiltersAction
extends AbstractTransportGetResourcesAction<MlFilter, GetFiltersAction.Request, GetFiltersAction.Response> {
    @Inject
    public TransportGetFiltersAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/filters/get", transportService, actionFilters, GetFiltersAction.Request::new, client, xContentRegistry);
    }

    protected void doExecute(Task task, GetFiltersAction.Request request, ActionListener<GetFiltersAction.Response> listener) {
        request.setAllowNoResources(true);
        this.searchResources((AbstractGetResourcesRequest)request, ActionListener.wrap(filters -> listener.onResponse((Object)new GetFiltersAction.Response(filters)), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ParseField getResultsField() {
        return MlFilter.RESULTS_FIELD;
    }

    protected String[] getIndices() {
        return new String[]{MlMetaIndex.indexName()};
    }

    protected MlFilter parse(XContentParser parser) throws IOException {
        return ((MlFilter.Builder)MlFilter.LENIENT_PARSER.parse(parser, null)).build();
    }

    protected ResourceNotFoundException notFoundException(String resourceId) {
        return new ResourceNotFoundException("Unable to find filter [" + resourceId + "]", new Object[0]);
    }

    protected String executionOrigin() {
        return "ml";
    }

    protected String extractIdFromResource(MlFilter mlFilter) {
        return mlFilter.getId();
    }

    protected QueryBuilder additionalQuery() {
        return QueryBuilders.termQuery((String)MlFilter.TYPE.getPreferredName(), (String)"filter");
    }
}

