/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.correlation;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class CountCorrelationIndicator
implements Writeable,
ToXContentObject {
    private static final ParseField EXPECTATIONS = new ParseField("expectations", new String[0]);
    private static final ParseField FRACTIONS = new ParseField("fractions", new String[0]);
    private static final ParseField DOC_COUNT = new ParseField("doc_count", new String[0]);
    private static final ConstructingObjectParser<CountCorrelationIndicator, Void> PARSER = new ConstructingObjectParser("correlative_value", a -> new CountCorrelationIndicator((List)a[0], (List)a[2], (long)((Long)a[1])));
    private final double[] expectations;
    private final double[] fractions;
    private final long docCount;

    private CountCorrelationIndicator(List<Double> values, List<Double> fractions, long docCount) {
        this(values.stream().mapToDouble(Double::doubleValue).toArray(), fractions == null ? null : fractions.stream().mapToDouble(Double::doubleValue).toArray(), docCount);
    }

    public CountCorrelationIndicator(double[] values, double[] fractions, long docCount) {
        Objects.requireNonNull(values);
        if (fractions != null && values.length != fractions.length) {
            throw new IllegalArgumentException("[expectations] and [fractions] must have the same length");
        }
        if (docCount <= 0L) {
            throw new IllegalArgumentException("[doc_count] must be a positive value");
        }
        if (values.length < 2) {
            throw new IllegalArgumentException("[expectations] must have a length of at least 2");
        }
        this.expectations = values;
        this.fractions = fractions;
        this.docCount = docCount;
    }

    public CountCorrelationIndicator(StreamInput in) throws IOException {
        this.expectations = in.readDoubleArray();
        this.fractions = in.readBoolean() ? in.readDoubleArray() : null;
        this.docCount = in.readVLong();
    }

    public static CountCorrelationIndicator fromXContent(XContentParser parser) {
        return (CountCorrelationIndicator)PARSER.apply(parser, null);
    }

    public double[] getExpectations() {
        return this.expectations;
    }

    public double[] getFractions() {
        return this.fractions;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountCorrelationIndicator that = (CountCorrelationIndicator)o;
        return this.docCount == that.docCount && Arrays.equals(this.expectations, that.expectations) && Arrays.equals(this.fractions, that.fractions);
    }

    public int hashCode() {
        return Objects.hash(this.docCount, Arrays.hashCode(this.expectations), Arrays.hashCode(this.fractions));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(EXPECTATIONS.getPreferredName(), (Object)this.expectations);
        if (this.fractions != null) {
            builder.field(FRACTIONS.getPreferredName(), (Object)this.fractions);
        }
        builder.field(DOC_COUNT.getPreferredName(), this.docCount);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.expectations);
        out.writeBoolean(this.fractions != null);
        if (this.fractions != null) {
            out.writeDoubleArray(this.fractions);
        }
        out.writeVLong(this.docCount);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), EXPECTATIONS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), DOC_COUNT);
        PARSER.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), FRACTIONS);
    }
}

