/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.rollup.action.GetRollupIndexCapsAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public final class DatafeedManager {
    private static final Logger logger = LogManager.getLogger(DatafeedManager.class);
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobConfigProvider jobConfigProvider;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final Client client;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;

    public DatafeedManager(DatafeedConfigProvider datafeedConfigProvider, JobConfigProvider jobConfigProvider, NamedXContentRegistry xContentRegistry, ClusterService clusterService, Settings settings, Client client) {
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.jobConfigProvider = jobConfigProvider;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
        this.client = client;
    }

    public void putDatafeed(PutDatafeedAction.Request request, ClusterState state, XPackLicenseState licenseState, SecurityContext securityContext, ThreadPool threadPool, ActionListener<PutDatafeedAction.Response> listener) {
        if (licenseState.isSecurityEnabled()) {
            SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(securityContext, () -> {
                String[] indices = request.getDatafeed().getIndices().toArray(new String[0]);
                String username = securityContext.getUser().principal();
                HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
                privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
                privRequest.username(username);
                privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
                RoleDescriptor.IndicesPrivileges.Builder indicesPrivilegesBuilder = RoleDescriptor.IndicesPrivileges.builder().indices(indices);
                ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, request, (HasPrivilegesResponse)r, state, threadPool, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                ActionListener getRollupIndexCapsActionHandler = ActionListener.wrap(response -> {
                    if (response.getJobs().isEmpty()) {
                        indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search"});
                    } else {
                        indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search", "indices:data/read/xpack/rollup/search"});
                    }
                    privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{indicesPrivilegesBuilder.build()});
                    this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
                }, e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                        indicesPrivilegesBuilder.privileges(new String[]{"indices:data/read/search"});
                        privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{indicesPrivilegesBuilder.build()});
                        this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
                    } else {
                        listener.onFailure(e);
                    }
                });
                if (RemoteClusterLicenseChecker.containsRemoteIndex((Collection)request.getDatafeed().getIndices())) {
                    getRollupIndexCapsActionHandler.onResponse((Object)new GetRollupIndexCapsAction.Response());
                } else {
                    ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetRollupIndexCapsAction.INSTANCE, (ActionRequest)new GetRollupIndexCapsAction.Request(indices), (ActionListener)getRollupIndexCapsActionHandler);
                }
            });
        } else {
            this.putDatafeed(request, threadPool.getThreadContext().getHeaders(), state, listener);
        }
    }

    public void getDatafeeds(GetDatafeedsAction.Request request, ActionListener<QueryPage<DatafeedConfig>> listener) {
        this.getDatafeeds(request, this.clusterService.state(), listener);
    }

    public void getDatafeeds(GetDatafeedsAction.Request request, ClusterState state, ActionListener<QueryPage<DatafeedConfig>> listener) {
        Map<String, DatafeedConfig> clusterStateConfigs = this.expandClusterStateDatafeeds(request.getDatafeedId(), request.allowNoMatch(), state);
        this.datafeedConfigProvider.expandDatafeedConfigs(request.getDatafeedId(), request.allowNoMatch(), (ActionListener<List<DatafeedConfig.Builder>>)ActionListener.wrap(datafeedBuilders -> {
            for (DatafeedConfig.Builder datafeed : datafeedBuilders) {
                if (!clusterStateConfigs.containsKey(datafeed.getId())) continue;
                listener.onFailure((Exception)new IllegalStateException("Datafeed [" + datafeed.getId() + "] configuration exists in both clusterstate and index"));
                return;
            }
            ArrayList<Object> datafeeds = new ArrayList<Object>(datafeedBuilders.size() + clusterStateConfigs.values().size());
            for (DatafeedConfig.Builder builder : datafeedBuilders) {
                datafeeds.add(builder.build());
            }
            datafeeds.addAll(clusterStateConfigs.values());
            Collections.sort(datafeeds, Comparator.comparing(DatafeedConfig::getId));
            listener.onResponse((Object)new QueryPage(datafeeds, (long)datafeeds.size(), DatafeedConfig.RESULTS_FIELD));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getDatafeedsByJobIds(Set<String> jobIds, ClusterState state, ActionListener<Map<String, DatafeedConfig.Builder>> listener) {
        this.datafeedConfigProvider.findDatafeedsByJobIds(jobIds, (ActionListener<Map<String, DatafeedConfig.Builder>>)ActionListener.wrap(datafeeds -> {
            HashMap<String, DatafeedConfig.Builder> response = new HashMap<String, DatafeedConfig.Builder>((Map<String, DatafeedConfig.Builder>)datafeeds);
            Map fromState = MlMetadata.getMlMetadata((ClusterState)state).getDatafeedsByJobIds(jobIds);
            for (Map.Entry datafeedConfigEntry : fromState.entrySet()) {
                DatafeedConfig.Builder alreadyExistingDatafeed = (DatafeedConfig.Builder)response.get(datafeedConfigEntry.getKey());
                if (alreadyExistingDatafeed != null) {
                    if (alreadyExistingDatafeed.getId().equals(((DatafeedConfig)datafeedConfigEntry.getValue()).getId())) {
                        listener.onFailure((Exception)new IllegalStateException("Datafeed [" + alreadyExistingDatafeed.getId() + "] configuration exists in both clusterstate and index"));
                        return;
                    }
                    listener.onFailure((Exception)new IllegalStateException("datafeed [" + ((DatafeedConfig)datafeedConfigEntry.getValue()).getId() + "] configuration in cluster state and [" + alreadyExistingDatafeed.getId() + "] in the configuration index both refer to job [" + (String)datafeedConfigEntry.getKey() + "]"));
                    return;
                }
                response.put((String)datafeedConfigEntry.getKey(), new DatafeedConfig.Builder((DatafeedConfig)datafeedConfigEntry.getValue()));
            }
            listener.onResponse(response);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void updateDatafeed(UpdateDatafeedAction.Request request, ClusterState state, SecurityContext securityContext, ThreadPool threadPool, ActionListener<PutDatafeedAction.Response> listener) {
        String datafeedId = request.getUpdate().getId();
        if (this.migrationEligibilityCheck.datafeedIsEligibleForMigration(request.getUpdate().getId(), state)) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.configHasNotBeenMigrated((String)"update datafeed", (String)request.getUpdate().getId())));
            return;
        }
        if (this.getDatafeedTask(state, request.getUpdate().getId()) != null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot update datafeed [{0}] while its status is {1}", (Object[])new Object[]{request.getUpdate().getId(), DatafeedState.STARTED}), (Object[])new Object[0])));
            return;
        }
        Runnable doUpdate = () -> ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)state, (TimeValue)request.masterNodeTimeout(), (ActionListener)ActionListener.wrap(bool -> SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(securityContext, () -> {
            Map headers = threadPool.getThreadContext().getHeaders();
            this.datafeedConfigProvider.updateDatefeedConfig(request.getUpdate().getId(), request.getUpdate(), headers, this.jobConfigProvider::validateDatafeedJob, (ActionListener<DatafeedConfig>)ActionListener.wrap(updatedConfig -> listener.onResponse((Object)new PutDatafeedAction.Response(updatedConfig)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        CheckedConsumer deleteTimingStatsAndUpdateConsumer = unused -> this.datafeedConfigProvider.getDatafeedConfig(datafeedId, (ActionListener<DatafeedConfig.Builder>)ActionListener.wrap(datafeedConfigBuilder -> {
            String jobId = datafeedConfigBuilder.build().getJobId();
            if (jobId.equals(request.getUpdate().getJobId())) {
                doUpdate.run();
            } else {
                JobDataDeleter jobDataDeleter = new JobDataDeleter(this.client, jobId);
                jobDataDeleter.deleteDatafeedTimingStats((ActionListener<BulkByScrollResponse>)ActionListener.wrap(b -> doUpdate.run(), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        if (request.getUpdate().getJobId() != null) {
            this.checkJobDoesNotHaveADifferentDatafeed(request.getUpdate().getJobId(), datafeedId, (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)deleteTimingStatsAndUpdateConsumer, arg_0 -> listener.onFailure(arg_0)));
        } else {
            doUpdate.run();
        }
    }

    public void deleteDatafeed(DeleteDatafeedAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (this.getDatafeedTask(state, request.getDatafeedId()) != null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot delete datafeed [{0}] while its status is {1}", (Object[])new Object[]{request.getDatafeedId(), DatafeedState.STARTED}), (Object[])new Object[0])));
            return;
        }
        String datafeedId = request.getDatafeedId();
        this.datafeedConfigProvider.getDatafeedConfig(datafeedId, (ActionListener<DatafeedConfig.Builder>)ActionListener.wrap(datafeedConfigBuilder -> {
            String jobId = datafeedConfigBuilder.build().getJobId();
            JobDataDeleter jobDataDeleter = new JobDataDeleter(this.client, jobId);
            jobDataDeleter.deleteDatafeedTimingStats((ActionListener<BulkByScrollResponse>)ActionListener.wrap(unused1 -> this.datafeedConfigProvider.deleteDatafeedConfig(datafeedId, (ActionListener<DeleteResponse>)ActionListener.wrap(unused2 -> listener.onResponse((Object)AcknowledgedResponse.TRUE), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private PersistentTasksCustomMetadata.PersistentTask<?> getDatafeedTask(ClusterState state, String datafeedId) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        return MlTasks.getDatafeedTask((String)datafeedId, (PersistentTasksCustomMetadata)tasks);
    }

    private Map<String, DatafeedConfig> expandClusterStateDatafeeds(String datafeedExpression, boolean allowNoMatch, ClusterState clusterState) {
        HashMap<String, DatafeedConfig> configById = new HashMap<String, DatafeedConfig>();
        try {
            MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
            Set expandedDatafeedIds = mlMetadata.expandDatafeedIds(datafeedExpression, allowNoMatch);
            for (String expandedDatafeedId : expandedDatafeedIds) {
                configById.put(expandedDatafeedId, mlMetadata.getDatafeed(expandedDatafeedId));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configById;
    }

    private void handlePrivsResponse(String username, PutDatafeedAction.Request request, HasPrivilegesResponse response, ClusterState clusterState, ThreadPool threadPool, ActionListener<PutDatafeedAction.Response> listener) throws IOException {
        if (response.isCompleteMatch()) {
            this.putDatafeed(request, threadPool.getThreadContext().getHeaders(), clusterState, listener);
        } else {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            for (ResourcePrivileges index : response.getIndexPrivileges()) {
                builder.field(index.getResource());
                builder.map(index.getPrivileges());
            }
            builder.endObject();
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot create datafeed [{}] because user {} lacks permissions on the indices: {}", (Object[])new Object[]{request.getDatafeed().getId(), username, Strings.toString((XContentBuilder)builder)}));
        }
    }

    private void putDatafeed(PutDatafeedAction.Request request, Map<String, String> headers, ClusterState clusterState, ActionListener<PutDatafeedAction.Response> listener) {
        String jobId;
        String datafeedId = request.getDatafeed().getId();
        ElasticsearchException validationError = this.checkConfigsAreNotDefinedInClusterState(datafeedId, jobId = request.getDatafeed().getJobId());
        if (validationError != null) {
            listener.onFailure((Exception)((Object)validationError));
            return;
        }
        DatafeedConfig.validateAggregations((AggregatorFactories.Builder)request.getDatafeed().getParsedAggregations(this.xContentRegistry));
        CheckedConsumer mappingsUpdated = ok -> this.datafeedConfigProvider.putDatafeedConfig(request.getDatafeed(), headers, (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> listener.onResponse((Object)new PutDatafeedAction.Response(request.getDatafeed())), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        CheckedConsumer validationOk = ok -> {
            if (clusterState == null) {
                logger.warn("Cannot update doc mapping because clusterState == null");
                mappingsUpdated.accept((Object)false);
                return;
            }
            ElasticsearchMappings.addDocMappingIfMissing((String)MlConfigIndex.indexName(), MlConfigIndex::mapping, (Client)this.client, (ClusterState)clusterState, (TimeValue)request.masterNodeTimeout(), (ActionListener)ActionListener.wrap((CheckedConsumer)mappingsUpdated, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        };
        CheckedConsumer jobOk = ok -> this.jobConfigProvider.validateDatafeedJob(request.getDatafeed(), (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)validationOk, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        this.checkJobDoesNotHaveADatafeed(jobId, (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)jobOk, arg_0 -> listener.onFailure(arg_0)));
    }

    @Nullable
    private ElasticsearchException checkConfigsAreNotDefinedInClusterState(String datafeedId, String jobId) {
        ClusterState clusterState = this.clusterService.state();
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)clusterState);
        if (mlMetadata.getDatafeed(datafeedId) != null) {
            return ExceptionsHelper.datafeedAlreadyExists((String)datafeedId);
        }
        if (mlMetadata.getDatafeedByJobId(jobId).isPresent()) {
            return ExceptionsHelper.conflictStatusException((String)("Cannot create datafeed [" + datafeedId + "] as a job [" + jobId + "] defined in the cluster state references a datafeed with the same Id"), (Object[])new Object[0]);
        }
        return null;
    }

    private void checkJobDoesNotHaveADatafeed(String jobId, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedIdsForJobIds(Collections.singletonList(jobId), (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            if (datafeedIds.isEmpty()) {
                listener.onResponse((Object)Boolean.TRUE);
            } else {
                listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)("A datafeed [" + (String)datafeedIds.iterator().next() + "] already exists for job [" + jobId + "]"), (Object[])new Object[0])));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkJobDoesNotHaveADifferentDatafeed(String jobId, String datafeedId, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedIdsForJobIds(Collections.singletonList(jobId), (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            if (datafeedIds.isEmpty()) {
                listener.onResponse((Object)Boolean.TRUE);
            } else if (datafeedIds.size() == 1 && datafeedIds.contains(datafeedId)) {
                listener.onResponse((Object)Boolean.TRUE);
            } else {
                listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)("A datafeed [" + (String)datafeedIds.iterator().next() + "] already exists for job [" + jobId + "]"), (Object[])new Object[0])));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

