/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import java.io.IOException;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesAction;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsDest;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.MappingsMerger;

public final class DestinationIndex {
    private static final Logger logger = LogManager.getLogger(DestinationIndex.class);
    public static final String INCREMENTAL_ID = "ml__incremental_id";
    public static final String IS_TRAINING = "is_training";
    static final String CREATION_DATE_MILLIS = "creation_date_in_millis";
    static final String VERSION = "version";
    static final String CREATED = "created";
    static final String CREATED_BY = "created_by";
    static final String ANALYTICS = "analytics";
    private static final String PROPERTIES = "properties";
    private static final String META = "_meta";
    private static final String RUNTIME = "runtime";
    private static final String DFA_CREATOR = "data-frame-analytics";
    private static final String[] PRESERVED_SETTINGS = new String[]{"index.number_of_shards", "index.number_of_replicas"};
    public static final Version MIN_COMPATIBLE_VERSION = StartDataFrameAnalyticsAction.TaskParams.VERSION_DESTINATION_INDEX_MAPPINGS_CHANGED;

    private DestinationIndex() {
    }

    public static void createDestinationIndex(Client client, Clock clock, DataFrameAnalyticsConfig analyticsConfig, ActionListener<CreateIndexResponse> listener) {
        ActionListener createIndexRequestListener = ActionListener.wrap(createIndexRequest -> ClientHelper.executeWithHeadersAsync((Map)analyticsConfig.getHeaders(), (String)"ml", (Client)client, (ActionType)CreateIndexAction.INSTANCE, (ActionRequest)createIndexRequest, (ActionListener)listener), arg_0 -> listener.onFailure(arg_0));
        DestinationIndex.prepareCreateIndexRequest(client, clock, analyticsConfig, (ActionListener<CreateIndexRequest>)createIndexRequestListener);
    }

    private static void prepareCreateIndexRequest(Client client, Clock clock, DataFrameAnalyticsConfig config, ActionListener<CreateIndexRequest> listener) {
        AtomicReference settingsHolder = new AtomicReference();
        AtomicReference mappingsHolder = new AtomicReference();
        ActionListener fieldCapabilitiesListener = ActionListener.wrap(fieldCapabilitiesResponse -> listener.onResponse((Object)DestinationIndex.createIndexRequest(clock, config, (Settings)settingsHolder.get(), (ImmutableOpenMap<String, MappingMetadata>)((ImmutableOpenMap)mappingsHolder.get()), fieldCapabilitiesResponse)), arg_0 -> listener.onFailure(arg_0));
        ActionListener mappingsListener = ActionListener.wrap(mappings -> {
            mappingsHolder.set(mappings);
            DestinationIndex.getFieldCapsForRequiredFields(client, config, (ActionListener<FieldCapabilitiesResponse>)fieldCapabilitiesListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener settingsListener = ActionListener.wrap(settings -> {
            settingsHolder.set(settings);
            MappingsMerger.mergeMappings(client, config.getHeaders(), config.getSource(), (ActionListener<ImmutableOpenMap<String, MappingMetadata>>)mappingsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getSettingsResponseListener = ActionListener.wrap(settingsResponse -> settingsListener.onResponse((Object)DestinationIndex.settings(settingsResponse)), arg_0 -> listener.onFailure(arg_0));
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(config.getSource().getIndex()).indicesOptions(IndicesOptions.lenientExpandOpen()).names(PRESERVED_SETTINGS);
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)GetSettingsAction.INSTANCE, (ActionRequest)getSettingsRequest, (ActionListener)getSettingsResponseListener);
    }

    private static void getFieldCapsForRequiredFields(Client client, DataFrameAnalyticsConfig config, ActionListener<FieldCapabilitiesResponse> listener) {
        List requiredFields = config.getAnalysis().getRequiredFields();
        if (requiredFields.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        FieldCapabilitiesRequest fieldCapabilitiesRequest = new FieldCapabilitiesRequest().indices(config.getSource().getIndex()).fields((String[])requiredFields.stream().map(RequiredField::getName).toArray(String[]::new)).runtimeFields(config.getSource().getRuntimeMappings());
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)FieldCapabilitiesAction.INSTANCE, (ActionRequest)fieldCapabilitiesRequest, listener);
    }

    private static CreateIndexRequest createIndexRequest(Clock clock, DataFrameAnalyticsConfig config, Settings settings, ImmutableOpenMap<String, MappingMetadata> mappings, FieldCapabilitiesResponse fieldCapabilitiesResponse) {
        assert (mappings.size() == 1);
        String destinationIndex = config.getDest().getIndex();
        String type = (String)mappings.keysIt().next();
        Map mappingsAsMap = ((MappingMetadata)mappings.valuesIt().next()).sourceAsMap();
        Map properties = DestinationIndex.getOrPutDefault(mappingsAsMap, PROPERTIES, HashMap::new);
        DestinationIndex.checkResultsFieldIsNotPresentInProperties(config, properties);
        properties.putAll(DestinationIndex.createAdditionalMappings(config, fieldCapabilitiesResponse));
        Map metadata = DestinationIndex.getOrPutDefault(mappingsAsMap, META, HashMap::new);
        metadata.putAll(DestinationIndex.createMetadata(config.getId(), clock, Version.CURRENT));
        if (!config.getSource().getRuntimeMappings().isEmpty()) {
            Map runtimeMappings = DestinationIndex.getOrPutDefault(mappingsAsMap, RUNTIME, HashMap::new);
            runtimeMappings.putAll(config.getSource().getRuntimeMappings());
        }
        return new CreateIndexRequest(destinationIndex, settings).mapping(type, mappingsAsMap);
    }

    private static Settings settings(GetSettingsResponse settingsResponse) {
        Integer maxNumberOfShards = DestinationIndex.findMaxSettingValue(settingsResponse, "index.number_of_shards");
        Integer maxNumberOfReplicas = DestinationIndex.findMaxSettingValue(settingsResponse, "index.number_of_replicas");
        Settings.Builder settingsBuilder = Settings.builder();
        if (maxNumberOfShards != null) {
            settingsBuilder.put("index.number_of_shards", maxNumberOfShards.intValue());
        }
        if (maxNumberOfReplicas != null) {
            settingsBuilder.put("index.number_of_replicas", maxNumberOfReplicas.intValue());
        }
        return settingsBuilder.build();
    }

    @Nullable
    private static Integer findMaxSettingValue(GetSettingsResponse settingsResponse, String settingKey) {
        Integer maxValue = null;
        Iterator settingsIterator = settingsResponse.getIndexToSettings().valuesIt();
        while (settingsIterator.hasNext()) {
            Settings settings = (Settings)settingsIterator.next();
            Integer indexValue = settings.getAsInt(settingKey, null);
            if (indexValue == null) continue;
            maxValue = maxValue == null ? indexValue : Math.max(indexValue, maxValue);
        }
        return maxValue;
    }

    private static Map<String, Object> createAdditionalMappings(DataFrameAnalyticsConfig config, FieldCapabilitiesResponse fieldCapabilitiesResponse) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, String> incrementalIdMapping = new HashMap<String, String>();
        incrementalIdMapping.put("type", NumberFieldMapper.NumberType.LONG.typeName());
        properties.put(INCREMENTAL_ID, incrementalIdMapping);
        properties.putAll(config.getAnalysis().getResultMappings(config.getDest().getResultsField(), fieldCapabilitiesResponse));
        return properties;
    }

    static Map<String, Object> createMetadata(String analyticsId, Clock clock, Version version) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(CREATION_DATE_MILLIS, clock.millis());
        metadata.put(CREATED_BY, DFA_CREATOR);
        HashMap<String, String> versionMapping = new HashMap<String, String>();
        versionMapping.put(CREATED, version.toString());
        metadata.put(VERSION, versionMapping);
        metadata.put(ANALYTICS, analyticsId);
        return metadata;
    }

    private static <K, V> V getOrPutDefault(Map<K, Object> map, K key, Supplier<V> valueSupplier) {
        Object value = map.get(key);
        if (value == null) {
            value = valueSupplier.get();
            map.put(key, value);
        }
        return (V)value;
    }

    public static void updateMappingsToDestIndex(Client client, DataFrameAnalyticsConfig config, GetIndexResponse getIndexResponse, ActionListener<AcknowledgedResponse> listener) {
        assert (getIndexResponse.indices().length == 1);
        ImmutableOpenMap<String, MappingMetadata> mappings = (ImmutableOpenMap<String, MappingMetadata>)getIndexResponse.getMappings().get((Object)getIndexResponse.indices()[0]);
        if (mappings.isEmpty()) {
            mappings = DestinationIndex.createEmptyMappings();
        }
        String type = (String)mappings.keysIt().next();
        Map destMappingsAsMap = ((MappingMetadata)mappings.valuesIt().next()).sourceAsMap();
        Map<String, Object> destPropertiesAsMap = destMappingsAsMap.getOrDefault(PROPERTIES, Collections.emptyMap());
        DestinationIndex.checkResultsFieldIsNotPresentInProperties(config, destPropertiesAsMap);
        ActionListener fieldCapabilitiesListener = ActionListener.wrap(fieldCapabilitiesResponse -> {
            HashMap<String, Map> addedMappings = new HashMap<String, Map>();
            addedMappings.put(PROPERTIES, DestinationIndex.createAdditionalMappings(config, fieldCapabilitiesResponse));
            if (!config.getSource().getRuntimeMappings().isEmpty()) {
                addedMappings.put(RUNTIME, config.getSource().getRuntimeMappings());
            }
            PutMappingRequest putMappingRequest = new PutMappingRequest(getIndexResponse.indices()).type(type).source(addedMappings);
            ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)client, (ActionType)PutMappingAction.INSTANCE, (ActionRequest)putMappingRequest, (ActionListener)listener);
        }, arg_0 -> listener.onFailure(arg_0));
        DestinationIndex.getFieldCapsForRequiredFields(client, config, (ActionListener<FieldCapabilitiesResponse>)fieldCapabilitiesListener);
    }

    private static ImmutableOpenMap<String, MappingMetadata> createEmptyMappings() {
        MappingMetadata singleDocEmptyMetadata;
        try {
            singleDocEmptyMetadata = new MappingMetadata("_doc", Collections.emptyMap());
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to create empty mapping_metadata");
        }
        return ImmutableOpenMap.builder().fPut((Object)"_doc", (Object)singleDocEmptyMetadata).build();
    }

    private static void checkResultsFieldIsNotPresentInProperties(DataFrameAnalyticsConfig config, Map<String, Object> properties) {
        String resultsField = config.getDest().getResultsField();
        if (properties.containsKey(resultsField)) {
            throw ExceptionsHelper.badRequestException((String)"A field that matches the {}.{} [{}] already exists; please set a different {}", (Object[])new Object[]{DataFrameAnalyticsConfig.DEST.getPreferredName(), DataFrameAnalyticsDest.RESULTS_FIELD.getPreferredName(), resultsField, DataFrameAnalyticsDest.RESULTS_FIELD.getPreferredName()});
        }
    }

    public static Metadata readMetadata(String jobId, @Nullable MappingMetadata mappingMetadata) {
        if (mappingMetadata == null) {
            return new NoMetadata();
        }
        Map mappings = mappingMetadata.getSourceAsMap();
        Map meta = (Map)mappings.get(META);
        if (meta == null || !DFA_CREATOR.equals(meta.get(CREATED_BY))) {
            return new NoMetadata();
        }
        return new DestMetadata(DestinationIndex.getVersion(jobId, meta));
    }

    private static Version getVersion(String jobId, Map<String, Object> meta) {
        try {
            Map version = (Map)meta.get(VERSION);
            String createdVersionString = (String)version.get(CREATED);
            return Version.fromString((String)createdVersionString);
        }
        catch (Exception e) {
            logger.error((Message)new ParameterizedMessage("[{}] Could not retrieve destination index version", (Object)jobId), (Throwable)e);
            return null;
        }
    }

    private static class NoMetadata
    implements Metadata {
        private NoMetadata() {
        }

        @Override
        public boolean hasMetadata() {
            return false;
        }

        @Override
        public boolean isCompatible() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DestMetadata
    implements Metadata {
        private final Version version;

        private DestMetadata(Version version) {
            this.version = version;
        }

        @Override
        public boolean hasMetadata() {
            return true;
        }

        @Override
        public boolean isCompatible() {
            return this.version == null ? false : this.version.onOrAfter(MIN_COMPATIBLE_VERSION);
        }

        @Override
        public String getVersion() {
            return this.version == null ? "unknown" : this.version.toString();
        }
    }

    public static interface Metadata {
        public boolean hasMetadata();

        public boolean isCompatible();

        public String getVersion();
    }
}

