/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.modelsize;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference.TreeInferenceModel;
import org.elasticsearch.xpack.ml.inference.modelsize.SizeEstimatorHelper;

public class TreeSizeInfo
implements Accountable,
ToXContentObject {
    private static final ParseField NUM_NODES = new ParseField("num_nodes", new String[0]);
    private static final ParseField NUM_LEAVES = new ParseField("num_leaves", new String[0]);
    private static final ParseField NUM_CLASSES = new ParseField("num_classes", new String[0]);
    static ConstructingObjectParser<TreeSizeInfo, Void> PARSER = new ConstructingObjectParser("tree_size", false, a -> new TreeSizeInfo((Integer)a[0], a[1] == null ? 0 : (Integer)a[1], a[2] == null ? 0 : (Integer)a[2]));
    private final int numNodes;
    private final int numLeaves;
    private int numClasses;

    public static TreeSizeInfo fromXContent(XContentParser parser) {
        return (TreeSizeInfo)PARSER.apply(parser, null);
    }

    TreeSizeInfo(int numLeaves, int numNodes, int numClasses) {
        this.numLeaves = numLeaves;
        this.numNodes = numNodes;
        this.numClasses = numClasses;
    }

    public TreeSizeInfo setNumClasses(int numClasses) {
        this.numClasses = numClasses;
        return this;
    }

    public long ramBytesUsed() {
        long size = TreeInferenceModel.SHALLOW_SIZE;
        size += (long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (this.numLeaves + this.numNodes) * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        size += (long)this.numLeaves * TreeInferenceModel.LeafNode.SHALLOW_SIZE;
        size += (long)this.numNodes * TreeInferenceModel.InnerNode.SHALLOW_SIZE;
        int numLeafVals = this.numClasses <= 2 ? 1 : this.numClasses;
        return RamUsageEstimator.alignObjectSize((long)(size += SizeEstimatorHelper.sizeOfDoubleArray(numLeafVals) * (long)this.numLeaves));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_LEAVES.getPreferredName(), this.numLeaves);
        builder.field(NUM_NODES.getPreferredName(), this.numNodes);
        builder.field(NUM_CLASSES.getPreferredName(), this.numClasses);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeSizeInfo treeSizeInfo = (TreeSizeInfo)o;
        return this.numNodes == treeSizeInfo.numNodes && this.numLeaves == treeSizeInfo.numLeaves && this.numClasses == treeSizeInfo.numClasses;
    }

    public int hashCode() {
        return Objects.hash(this.numNodes, this.numLeaves, this.numClasses);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), NUM_LEAVES);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_NODES);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_CLASSES);
    }
}

