/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.topmetrics;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregationBuilder;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregator;

public class TopMetricsAggregatorFactory
extends AggregatorFactory {
    public static final Setting<Integer> MAX_BUCKET_SIZE = Setting.intSetting((String)"index.top_metrics_max_size", (int)10, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});
    private final List<SortBuilder<?>> sortBuilders;
    private final int size;
    private final List<MultiValuesSourceFieldConfig> metricFields;

    public TopMetricsAggregatorFactory(String name, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, List<SortBuilder<?>> sortBuilders, int size, List<MultiValuesSourceFieldConfig> metricFields) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.sortBuilders = sortBuilders;
        this.size = size;
        this.metricFields = metricFields;
    }

    protected TopMetricsAggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        int maxBucketSize = (Integer)MAX_BUCKET_SIZE.get(this.context.getIndexSettings().getSettings());
        if (this.size > maxBucketSize) {
            throw new IllegalArgumentException("[top_metrics.size] must not be more than [" + maxBucketSize + "] but was [" + this.size + "]. This limit can be set by changing the [" + MAX_BUCKET_SIZE.getKey() + "] index level setting.");
        }
        TopMetricsAggregator.MetricValues[] metricValues = new TopMetricsAggregator.MetricValues[this.metricFields.size()];
        for (int i = 0; i < this.metricFields.size(); ++i) {
            MultiValuesSourceFieldConfig config = this.metricFields.get(i);
            ValuesSourceConfig vsConfig = ValuesSourceConfig.resolve((AggregationContext)this.context, null, (String)config.getFieldName(), (Script)config.getScript(), (Object)config.getMissing(), (ZoneId)config.getTimeZone(), null, (ValuesSourceType)CoreValuesSourceType.NUMERIC);
            TopMetricsAggregator.MetricValuesSupplier supplier = (TopMetricsAggregator.MetricValuesSupplier)this.context.getValuesSourceRegistry().getAggregator(TopMetricsAggregationBuilder.REGISTRY_KEY, vsConfig);
            metricValues[i] = supplier.build(this.size, this.context.bigArrays(), config.getFieldName(), vsConfig);
        }
        return new TopMetricsAggregator(this.name, this.context, parent, metadata, this.size, this.sortBuilders.get(0), metricValues);
    }
}

