/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.querydsl.container.AttributeSort;
import org.elasticsearch.xpack.ql.querydsl.container.ScriptSort;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.sql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.sql.querydsl.container.ScoreSort;

public abstract class SourceGenerator {
    private SourceGenerator() {
    }

    public static SearchSourceBuilder sourceBuilder(QueryContainer container, QueryBuilder filter, Integer size) {
        Object finalQuery = null;
        if (container.query() != null) {
            finalQuery = filter != null ? QueryBuilders.boolQuery().must(container.query().asBuilder()).filter(filter) : container.query().asBuilder();
        } else if (filter != null) {
            finalQuery = QueryBuilders.boolQuery().filter(filter);
        }
        SearchSourceBuilder source = new SearchSourceBuilder();
        source.query(finalQuery);
        QlSourceBuilder sortBuilder = new QlSourceBuilder();
        container.fields().forEach(f -> ((FieldExtraction)f.v1()).collectFields(sortBuilder));
        sortBuilder.build(source);
        AggregationBuilder aggBuilder = container.aggs().asAggBuilder();
        if (aggBuilder != null) {
            source.aggregation(aggBuilder);
        }
        SourceGenerator.sorting(container, source);
        if (size != null) {
            int sz = container.limit() > 0 ? Math.min(container.limit(), size) : size;
            int minSize = container.minPageSize();
            int n = sz = minSize > 0 ? Math.max(sz / minSize, 1) * minSize : sz;
            if (source.size() == -1) {
                source.size(sz);
            }
            if (aggBuilder instanceof CompositeAggregationBuilder) {
                if (container.sortingColumns().isEmpty()) {
                    ((CompositeAggregationBuilder)aggBuilder).size(sz);
                } else {
                    ((CompositeAggregationBuilder)aggBuilder).size(size.intValue());
                }
            }
        }
        SourceGenerator.optimize(container, source);
        return source;
    }

    private static void sorting(QueryContainer container, SearchSourceBuilder source) {
        if (source.aggregations() != null && source.aggregations().count() > 0) {
            return;
        }
        if (container.sort() == null || container.sort().isEmpty()) {
            source.sort("_doc");
            return;
        }
        for (Sort sortable : container.sort().values()) {
            ScoreSortBuilder sortBuilder = null;
            if (sortable instanceof AttributeSort) {
                AttributeSort as = (AttributeSort)sortable;
                Attribute attr = as.attribute();
                if (attr instanceof FieldAttribute) {
                    FieldAttribute fa = ((FieldAttribute)attr).exactAttribute();
                    sortBuilder = SortBuilders.fieldSort((String)fa.name()).missing((Object)as.missing().position()).unmappedType(fa.dataType().esType());
                    if (fa.isNested()) {
                        FieldSortBuilder fieldSort = SortBuilders.fieldSort((String)fa.name()).missing((Object)as.missing().position()).unmappedType(fa.dataType().esType());
                        NestedSortBuilder newSort = new NestedSortBuilder(fa.nestedParent().name());
                        NestedSortBuilder nestedSort = fieldSort.getNestedSort();
                        if (nestedSort == null) {
                            fieldSort.setNestedSort(newSort);
                        } else {
                            while (nestedSort.getNestedSort() != null) {
                                nestedSort = nestedSort.getNestedSort();
                            }
                            nestedSort.setNestedSort(newSort);
                        }
                        nestedSort = newSort;
                        if (container.query() != null) {
                            container.query().enrichNestedSort(nestedSort);
                        }
                        sortBuilder = fieldSort;
                    }
                }
            } else if (sortable instanceof ScriptSort) {
                ScriptSort ss = (ScriptSort)sortable;
                sortBuilder = SortBuilders.scriptSort((Script)ss.script().toPainless(), (ScriptSortBuilder.ScriptSortType)(ss.script().outputType().isNumeric() ? ScriptSortBuilder.ScriptSortType.NUMBER : ScriptSortBuilder.ScriptSortType.STRING));
            } else if (sortable instanceof ScoreSort) {
                sortBuilder = SortBuilders.scoreSort();
            }
            if (sortBuilder == null) continue;
            sortBuilder.order(sortable.direction().asOrder());
            source.sort((SortBuilder)sortBuilder);
        }
    }

    private static void optimize(QueryContainer query, SearchSourceBuilder builder) {
        if (query.isAggsOnly()) {
            builder.size(0);
            builder.trackScores(false);
        }
        if (query.shouldTrackHits()) {
            builder.trackTotalHits(true);
        }
        builder.fetchSource(FetchSourceContext.DO_NOT_FETCH_SOURCE);
    }
}

