/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringFunctionUtils;
import org.elasticsearch.xpack.sql.util.Check;

public class SubstringFunctionProcessor
implements Processor {
    public static final String NAME = "ssub";
    private final Processor input;
    private final Processor start;
    private final Processor length;

    public SubstringFunctionProcessor(Processor input, Processor start, Processor length) {
        this.input = input;
        this.start = start;
        this.length = length;
    }

    public SubstringFunctionProcessor(StreamInput in) throws IOException {
        this.input = (Processor)in.readNamedWriteable(Processor.class);
        this.start = (Processor)in.readNamedWriteable(Processor.class);
        this.length = (Processor)in.readNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.input);
        out.writeNamedWriteable((NamedWriteable)this.start);
        out.writeNamedWriteable((NamedWriteable)this.length);
    }

    public Object process(Object o) {
        return SubstringFunctionProcessor.doProcess(this.input.process(o), this.start.process(o), this.length.process(o));
    }

    public static Object doProcess(Object input, Object start, Object length) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof String || input instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", input);
        }
        if (start == null || length == null) {
            return null;
        }
        Check.isFixedNumberAndInRange(start, "start", -2147483647L, Integer.MAX_VALUE);
        Check.isFixedNumberAndInRange(length, "length", 0L, Integer.MAX_VALUE);
        return StringFunctionUtils.substring(input instanceof Character ? input.toString() : (String)input, ((Number)start).intValue() - 1, ((Number)length).intValue());
    }

    protected Processor input() {
        return this.input;
    }

    protected Processor start() {
        return this.start;
    }

    protected Processor length() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubstringFunctionProcessor other = (SubstringFunctionProcessor)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.length(), other.length());
    }

    public int hashCode() {
        return Objects.hash(this.input(), this.start(), this.length());
    }

    public String getWriteableName() {
        return NAME;
    }
}

