/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.plan.QueryPlan;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.KeywordEsField;
import org.elasticsearch.xpack.ql.util.Graphviz;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.planner.Planner;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class Explain
extends Command {
    private final LogicalPlan plan;
    private final boolean verify;
    private final Format format;
    private final Type type;

    public Explain(Source source, LogicalPlan plan, Type type, Format format, boolean verify) {
        super(source);
        this.plan = plan;
        this.verify = verify;
        this.format = format == null ? Format.TEXT : format;
        this.type = type == null ? Type.ANALYZED : type;
    }

    protected NodeInfo<Explain> info() {
        return NodeInfo.create((Node)this, Explain::new, (Object)this.plan, (Object)((Object)this.type), (Object)((Object)this.format), (Object)this.verify);
    }

    public LogicalPlan plan() {
        return this.plan;
    }

    public boolean verify() {
        return this.verify;
    }

    public Format format() {
        return this.format;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public List<Attribute> output() {
        return Collections.singletonList(new FieldAttribute(this.source(), "plan", (EsField)new KeywordEsField("plan")));
    }

    @Override
    public void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        if (this.type == Type.PARSED) {
            listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, (QueryPlan<?>)this.plan))));
            return;
        }
        session.analyzedPlan(this.plan, this.verify, (ActionListener<LogicalPlan>)ActionListener.wrap(analyzedPlan -> {
            if (this.type == Type.ANALYZED) {
                listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, (QueryPlan<?>)analyzedPlan))));
                return;
            }
            Planner planner = session.planner();
            if (this.verify) {
                session.optimizedPlan((LogicalPlan)analyzedPlan, (ActionListener<LogicalPlan>)ActionListener.wrap(optimizedPlan -> {
                    if (this.type == Type.OPTIMIZED) {
                        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, (QueryPlan<?>)optimizedPlan))));
                        return;
                    }
                    PhysicalPlan mappedPlan = planner.mapPlan((LogicalPlan)optimizedPlan, this.verify);
                    if (this.type == Type.MAPPED) {
                        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, mappedPlan))));
                        return;
                    }
                    PhysicalPlan executablePlan = planner.foldPlan(mappedPlan, this.verify);
                    if (this.type == Type.EXECUTABLE) {
                        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, executablePlan))));
                        return;
                    }
                    listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), Explain.printPlans(this.format, this.plan, analyzedPlan, optimizedPlan, mappedPlan, executablePlan))));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else if (session.verifier().verifyFailures((LogicalPlan)analyzedPlan).isEmpty()) {
                session.optimizedPlan((LogicalPlan)analyzedPlan, (ActionListener<LogicalPlan>)ActionListener.wrap(optimizedPlan -> {
                    if (this.type == Type.OPTIMIZED) {
                        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, (QueryPlan<?>)optimizedPlan))));
                        return;
                    }
                    PhysicalPlan mappedPlan = planner.mapPlan((LogicalPlan)optimizedPlan, this.verify);
                    if (this.type == Type.MAPPED) {
                        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, mappedPlan))));
                        return;
                    }
                    if (planner.verifyMappingPlanFailures(mappedPlan).isEmpty()) {
                        PhysicalPlan executablePlan = planner.foldPlan(mappedPlan, this.verify);
                        if (this.type == Type.EXECUTABLE) {
                            listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, executablePlan))));
                            return;
                        }
                        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), Explain.printPlans(this.format, this.plan, analyzedPlan, optimizedPlan, mappedPlan, executablePlan))));
                        return;
                    }
                    if (this.type != Type.ALL) {
                        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, mappedPlan))));
                        return;
                    }
                    listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), Explain.printPlans(this.format, this.plan, analyzedPlan, optimizedPlan, mappedPlan, null))));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else if (this.type != Type.ALL) {
                listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), this.formatPlan(this.format, (QueryPlan<?>)analyzedPlan))));
            } else {
                listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), Explain.printPlans(this.format, this.plan, analyzedPlan, null, null, null))));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static String printPlans(Format format, LogicalPlan parsed, LogicalPlan analyzedPlan, LogicalPlan optimizedPlan, PhysicalPlan mappedPlan, PhysicalPlan executionPlan) {
        if (format == Format.TEXT) {
            StringBuilder sb = new StringBuilder();
            sb.append("Parsed\n");
            sb.append("-----------\n");
            sb.append(parsed.toString());
            sb.append("\nAnalyzed\n");
            sb.append("--------\n");
            sb.append(analyzedPlan.toString());
            sb.append("\nOptimized\n");
            sb.append("---------\n");
            sb.append(Explain.nullablePlan(optimizedPlan));
            sb.append("\nMapped\n");
            sb.append("---------\n");
            sb.append(Explain.nullablePlan(mappedPlan));
            sb.append("\nExecutable\n");
            sb.append("---------\n");
            sb.append(Explain.nullablePlan(executionPlan));
            return sb.toString();
        }
        HashMap<String, Object> plans = new HashMap<String, Object>();
        plans.put("Parsed", parsed);
        plans.put("Analyzed", analyzedPlan);
        if (optimizedPlan != null) {
            plans.put("Optimized", optimizedPlan);
            plans.put("Mapped", mappedPlan);
            plans.put("Execution", executionPlan);
        }
        return Graphviz.dot(Collections.unmodifiableMap(plans), (boolean)false);
    }

    private static String nullablePlan(QueryPlan<?> plan) {
        return plan != null ? plan.toString() : "<not computed due to failures>";
    }

    private String formatPlan(Format format, QueryPlan<?> plan) {
        return format == Format.TEXT ? Explain.nullablePlan(plan) : Graphviz.dot((String)this.type.printableName(), plan);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.plan, this.type, this.format, this.verify});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Explain o = (Explain)obj;
        return Objects.equals(this.verify, o.verify) && Objects.equals((Object)this.format, (Object)o.format) && Objects.equals((Object)this.type, (Object)o.type) && Objects.equals(this.plan, o.plan);
    }

    public static enum Format {
        TEXT,
        GRAPHVIZ;

    }

    public static enum Type {
        PARSED,
        ANALYZED,
        OPTIMIZED,
        MAPPED,
        EXECUTABLE,
        ALL;


        public String printableName() {
            return Strings.capitalize((String)this.name().toLowerCase(Locale.ROOT));
        }
    }
}

