/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.ql.index.IndexResolver;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SqlSession;

public class SysTables
extends Command {
    private final String index;
    private final LikePattern pattern;
    private final LikePattern clusterPattern;
    private final EnumSet<IndexResolver.IndexType> types;

    public SysTables(Source source, LikePattern clusterPattern, String index, LikePattern pattern, EnumSet<IndexResolver.IndexType> types) {
        super(source);
        this.clusterPattern = clusterPattern;
        this.index = index;
        this.pattern = pattern;
        this.types = types;
    }

    protected NodeInfo<SysTables> info() {
        return NodeInfo.create((Node)this, SysTables::new, (Object)this.clusterPattern, (Object)this.index, (Object)this.pattern, this.types);
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(this.keyword("TABLE_CAT"), this.keyword("TABLE_SCHEM"), this.keyword("TABLE_NAME"), this.keyword("TABLE_TYPE"), this.keyword("REMARKS"), this.keyword("TYPE_CAT"), this.keyword("TYPE_SCHEM"), this.keyword("TYPE_NAME"), this.keyword("SELF_REFERENCING_COL_NAME"), this.keyword("REF_GENERATION"));
    }

    @Override
    public final void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        String cRegex;
        String cluster = session.indexResolver().clusterName();
        if ((this.clusterPattern == null || this.clusterPattern.pattern().equals("%")) && this.pattern != null && this.pattern.pattern().isEmpty() && this.index == null && this.types == null) {
            Object[] enumeration = new Object[10];
            enumeration[0] = cluster;
            listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), enumeration)));
            return;
        }
        boolean includeFrozen = session.configuration().includeFrozen();
        if (this.types == null && this.clusterPattern != null && this.clusterPattern.pattern().isEmpty() && this.pattern != null && this.pattern.pattern().isEmpty() && this.index == null) {
            ArrayList values = new ArrayList();
            EnumSet typeSet = IndexResolver.IndexType.VALID_REGULAR;
            for (IndexResolver.IndexType type : typeSet) {
                Object[] enumeration = new Object[10];
                enumeration[3] = type.toSql();
                values.add(Arrays.asList(enumeration));
            }
            values.sort(Comparator.comparing(l -> l.get(3).toString()));
            listener.onResponse((Object)this.of(session, values));
            return;
        }
        String string = cRegex = this.clusterPattern != null ? this.clusterPattern.asJavaRegex() : null;
        if (cRegex != null && !Pattern.matches(cRegex, cluster)) {
            listener.onResponse((Object)Cursor.Page.last(Rows.empty(this.output())));
            return;
        }
        String idx = this.index != null ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        String regex = this.pattern != null ? this.pattern.asJavaRegex() : null;
        EnumSet tableTypes = this.types;
        if (tableTypes == null) {
            tableTypes = includeFrozen ? IndexResolver.IndexType.VALID_INCLUDE_FROZEN : IndexResolver.IndexType.VALID_REGULAR;
        } else if (includeFrozen && !tableTypes.contains(IndexResolver.IndexType.FROZEN_INDEX)) {
            tableTypes.add(IndexResolver.IndexType.FROZEN_INDEX);
        }
        session.indexResolver().resolveNames(idx, regex, tableTypes, ActionListener.wrap(result -> listener.onResponse((Object)this.of(session, result.stream().sorted(Comparator.comparing(i -> i.type().toSql()).thenComparing(Comparator.comparing(i -> i.name()))).map(t -> Arrays.asList(cluster, null, t.name(), t.type().toSql(), "", null, null, null, null, null)).collect(Collectors.toList()))), arg_0 -> listener.onFailure(arg_0)));
    }

    public int hashCode() {
        return Objects.hash(this.clusterPattern, this.index, this.pattern, this.types);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SysTables other = (SysTables)obj;
        return Objects.equals(this.clusterPattern, other.clusterPattern) && Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.types, other.types);
    }
}

