/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.container;

import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.sql.querydsl.container.FieldReference;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class SearchHitFieldRef
extends FieldReference {
    private final String name;
    private final DataType dataType;
    private final String hitName;

    public SearchHitFieldRef(String name, DataType dataType) {
        this(name, dataType, null);
    }

    public SearchHitFieldRef(String name, DataType dataType, String hitName) {
        this.name = name;
        this.dataType = dataType;
        this.hitName = hitName;
    }

    public String hitName() {
        return this.hitName;
    }

    @Override
    public String name() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void collectFields(QlSourceBuilder sourceBuilder) {
        if (this.hitName != null) {
            return;
        }
        sourceBuilder.addFetchField(this.name, SqlDataTypes.format(this.dataType));
    }

    public String toString() {
        return this.name;
    }
}

