/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Tuple;

public class ScriptLanguagesInfo
implements ToXContentObject,
Writeable {
    private static final ParseField TYPES_ALLOWED = new ParseField("types_allowed", new String[0]);
    private static final ParseField LANGUAGE_CONTEXTS = new ParseField("language_contexts", new String[0]);
    private static final ParseField LANGUAGE = new ParseField("language", new String[0]);
    private static final ParseField CONTEXTS = new ParseField("contexts", new String[0]);
    public final Set<String> typesAllowed;
    public final Map<String, Set<String>> languageContexts;
    public static final ConstructingObjectParser<ScriptLanguagesInfo, Void> PARSER = new ConstructingObjectParser("script_languages_info", true, a -> new ScriptLanguagesInfo(new HashSet<String>((List)a[0]), ((List)a[1]).stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2))));
    private static final ConstructingObjectParser<Tuple<String, Set<String>>, Void> LANGUAGE_CONTEXT_PARSER = new ConstructingObjectParser("language_contexts", true, (m, name) -> new Tuple((Object)((String)m[0]), Collections.unmodifiableSet(new HashSet((List)m[1]))));

    public ScriptLanguagesInfo(Set<String> typesAllowed, Map<String, Set<String>> languageContexts) {
        this.typesAllowed = typesAllowed != null ? Collections.unmodifiableSet(typesAllowed) : Collections.emptySet();
        this.languageContexts = languageContexts != null ? Collections.unmodifiableMap(languageContexts) : Collections.emptyMap();
    }

    public ScriptLanguagesInfo(StreamInput in) throws IOException {
        this.typesAllowed = in.readSet(StreamInput::readString);
        this.languageContexts = in.readMap(StreamInput::readString, sin -> sin.readSet(StreamInput::readString));
    }

    public static ScriptLanguagesInfo fromXContent(XContentParser parser) throws IOException {
        return (ScriptLanguagesInfo)PARSER.parse(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.typesAllowed);
        out.writeMap(this.languageContexts, StreamOutput::writeString, StreamOutput::writeStringCollection);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptLanguagesInfo that = (ScriptLanguagesInfo)o;
        return Objects.equals(this.typesAllowed, that.typesAllowed) && Objects.equals(this.languageContexts, that.languageContexts);
    }

    public int hashCode() {
        return Objects.hash(this.typesAllowed, this.languageContexts);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startArray(TYPES_ALLOWED.getPreferredName());
        for (String type : this.typesAllowed.stream().sorted().collect(Collectors.toList())) {
            builder.value(type);
        }
        builder.endArray().startArray(LANGUAGE_CONTEXTS.getPreferredName());
        List languagesByName = this.languageContexts.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        for (Map.Entry languageContext : languagesByName) {
            builder.startObject().field(LANGUAGE.getPreferredName(), (String)languageContext.getKey()).startArray(CONTEXTS.getPreferredName());
            for (String context : ((Set)languageContext.getValue()).stream().sorted().collect(Collectors.toList())) {
                builder.value(context);
            }
            builder.endArray().endObject();
        }
        return builder.endArray().endObject();
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), TYPES_ALLOWED);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), LANGUAGE_CONTEXT_PARSER, LANGUAGE_CONTEXTS);
        LANGUAGE_CONTEXT_PARSER.declareString(ConstructingObjectParser.constructorArg(), LANGUAGE);
        LANGUAGE_CONTEXT_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), CONTEXTS);
    }
}

