/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedValueFetcher;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.lookup.SourceLookup;

public class FieldFetcher {
    private static final int AUTOMATON_MAX_DETERMINIZED_STATES = 100000;
    private final Map<String, FieldContext> fieldContexts;
    private final CharacterRunAutomaton unmappedFieldsFetchAutomaton;
    private final List<String> unmappedConcreteFields;

    public static FieldFetcher create(SearchExecutionContext context, Collection<FieldAndFormat> fieldAndFormats) {
        Set<String> nestedMappingPaths = context.hasNested() ? context.nestedMappings().stream().map(ObjectMapper::name).collect(Collectors.toSet()) : Collections.emptySet();
        return FieldFetcher.create(context, fieldAndFormats, nestedMappingPaths, "");
    }

    private static FieldFetcher create(SearchExecutionContext context, Collection<FieldAndFormat> fieldAndFormats, Set<String> nestedMappingsInScope, String nestedScopePath) {
        Set<String> nestedParentPaths = FieldFetcher.getParentPaths(nestedMappingsInScope, context);
        LinkedHashMap<String, FieldContext> fieldContexts = new LinkedHashMap<String, FieldContext>();
        ArrayList<String> unmappedFetchPattern = new ArrayList<String>();
        for (FieldAndFormat fieldAndFormat : fieldAndFormats) {
            String fieldPattern = fieldAndFormat.field;
            boolean isWildcardPattern = Regex.isSimpleMatchPattern(fieldPattern);
            if (fieldAndFormat.includeUnmapped != null && fieldAndFormat.includeUnmapped.booleanValue()) {
                unmappedFetchPattern.add(fieldAndFormat.field);
            }
            for (String field : context.getMatchingFieldNames(fieldPattern)) {
                MappedFieldType ft = context.getFieldType(field);
                if (context.isMetadataField(field) && isWildcardPattern || !field.startsWith(nestedScopePath)) continue;
                String nestedParentPath = null;
                if (!nestedParentPaths.isEmpty()) {
                    for (String nestedFieldPath : nestedParentPaths) {
                        if (!field.startsWith(nestedFieldPath)) continue;
                        nestedParentPath = nestedFieldPath;
                        break;
                    }
                }
                if (nestedParentPath != null) continue;
                ValueFetcher valueFetcher = ft.valueFetcher(context, fieldAndFormat.format);
                fieldContexts.put(field, new FieldContext(field, valueFetcher));
            }
        }
        for (String nestedFieldPath : nestedParentPaths) {
            Set<String> narrowedScopeNestedMappings = nestedMappingsInScope.stream().filter(s -> !nestedParentPaths.contains(s)).collect(Collectors.toSet());
            FieldFetcher nestedSubFieldFetcher = FieldFetcher.create(context, fieldAndFormats, narrowedScopeNestedMappings, nestedFieldPath);
            fieldContexts.put(nestedFieldPath, new FieldContext(nestedFieldPath, new NestedValueFetcher(nestedFieldPath, nestedSubFieldFetcher)));
        }
        CharacterRunAutomaton unmappedFieldsFetchAutomaton = null;
        Map<Boolean, List<String>> partitions = unmappedFetchPattern.stream().collect(Collectors.partitioningBy(s -> Regex.isSimpleMatchPattern(s)));
        List<String> unmappedWildcardPattern = partitions.get(true);
        List<String> unmappedConcreteFields = partitions.get(false);
        if (!unmappedWildcardPattern.isEmpty()) {
            unmappedFieldsFetchAutomaton = new CharacterRunAutomaton(Regex.simpleMatchToAutomaton(unmappedWildcardPattern.toArray(new String[unmappedWildcardPattern.size()])), 100000);
        }
        return new FieldFetcher(fieldContexts, unmappedFieldsFetchAutomaton, unmappedConcreteFields);
    }

    private FieldFetcher(Map<String, FieldContext> fieldContexts, @Nullable CharacterRunAutomaton unmappedFieldsFetchAutomaton, @Nullable List<String> unmappedConcreteFields) {
        this.fieldContexts = fieldContexts;
        this.unmappedFieldsFetchAutomaton = unmappedFieldsFetchAutomaton;
        this.unmappedConcreteFields = unmappedConcreteFields;
    }

    public Map<String, DocumentField> fetch(SourceLookup sourceLookup) throws IOException {
        HashMap<String, DocumentField> documentFields = new HashMap<String, DocumentField>();
        for (FieldContext context : this.fieldContexts.values()) {
            String field = context.fieldName;
            ValueFetcher valueFetcher = context.valueFetcher;
            List<Object> parsedValues = valueFetcher.fetchValues(sourceLookup);
            if (parsedValues.isEmpty()) continue;
            documentFields.put(field, new DocumentField(field, parsedValues));
        }
        this.collectUnmapped(documentFields, sourceLookup.source(), "", 0);
        return documentFields;
    }

    private void collectUnmapped(Map<String, DocumentField> documentFields, Map<String, Object> source, String parentPath, int lastState) {
        if (this.unmappedFieldsFetchAutomaton != null) {
            for (String key : source.keySet()) {
                int currentState;
                Object value = source.get(key);
                String currentPath = parentPath + key;
                if (this.fieldContexts.containsKey(currentPath) || (currentState = FieldFetcher.step(this.unmappedFieldsFetchAutomaton, key, lastState)) == -1) continue;
                if (value instanceof Map) {
                    Map objectMap = (Map)value;
                    this.collectUnmapped(documentFields, objectMap, currentPath + ".", FieldFetcher.step(this.unmappedFieldsFetchAutomaton, ".", currentState));
                    continue;
                }
                if (value instanceof List) {
                    this.collectUnmappedList(documentFields, (List)value, currentPath, currentState);
                    continue;
                }
                if (!this.unmappedFieldsFetchAutomaton.isAccept(currentState) || value == null) continue;
                DocumentField currentEntry = documentFields.get(currentPath);
                if (currentEntry == null) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(value);
                    documentFields.put(currentPath, new DocumentField(currentPath, list));
                    continue;
                }
                currentEntry.getValues().add(value);
            }
        }
        if (this.unmappedConcreteFields != null) {
            for (String path : this.unmappedConcreteFields) {
                List<Object> values;
                if (this.fieldContexts.containsKey(path) || (values = XContentMapValues.extractRawValues(path, source)).isEmpty()) continue;
                documentFields.put(path, new DocumentField(path, values));
            }
        }
    }

    private void collectUnmappedList(Map<String, DocumentField> documentFields, Iterable<?> iterable, String parentPath, int lastState) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : iterable) {
            if (value instanceof Map) {
                Map objectMap = (Map)value;
                this.collectUnmapped(documentFields, objectMap, parentPath + ".", FieldFetcher.step(this.unmappedFieldsFetchAutomaton, ".", lastState));
                continue;
            }
            if (value instanceof List) {
                this.collectUnmappedList(documentFields, (List)value, parentPath, lastState);
                continue;
            }
            if (!this.unmappedFieldsFetchAutomaton.isAccept(lastState) || this.fieldContexts.containsKey(parentPath)) continue;
            list.add(value);
        }
        if (!list.isEmpty()) {
            DocumentField currentEntry = documentFields.get(parentPath);
            if (currentEntry == null) {
                documentFields.put(parentPath, new DocumentField(parentPath, list));
            } else {
                currentEntry.getValues().addAll(list);
            }
        }
    }

    private static Set<String> getParentPaths(Set<String> nestedPathsInScope, SearchExecutionContext context) {
        HashSet<String> parentPaths = new HashSet<String>();
        for (String candidate : nestedPathsInScope) {
            String nestedParent = context.getNestedParent(candidate);
            if (nestedParent != null && nestedPathsInScope.contains(nestedParent)) continue;
            parentPaths.add(candidate);
        }
        return parentPaths;
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, (int)key.charAt(i));
        }
        return state;
    }

    public void setNextReader(LeafReaderContext readerContext) {
        for (FieldContext field : this.fieldContexts.values()) {
            field.valueFetcher.setNextReader(readerContext);
        }
    }

    private static class FieldContext {
        final String fieldName;
        final ValueFetcher valueFetcher;

        FieldContext(String fieldName, ValueFetcher valueFetcher) {
            this.fieldName = fieldName;
            this.valueFetcher = valueFetcher;
        }
    }
}

