/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.eql.execution.PlanExecutor;
import org.elasticsearch.xpack.eql.plugin.EqlStatsRequest;
import org.elasticsearch.xpack.eql.plugin.EqlStatsResponse;

public class TransportEqlStatsAction
extends TransportNodesAction<EqlStatsRequest, EqlStatsResponse, EqlStatsRequest.NodeStatsRequest, EqlStatsResponse.NodeStatsResponse> {
    private final PlanExecutor planExecutor;

    @Inject
    public TransportEqlStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor) {
        super("cluster:monitor/xpack/eql/stats/dist", threadPool, clusterService, transportService, actionFilters, EqlStatsRequest::new, EqlStatsRequest.NodeStatsRequest::new, "management", EqlStatsResponse.NodeStatsResponse.class);
        this.planExecutor = planExecutor;
    }

    protected EqlStatsResponse newResponse(EqlStatsRequest request, List<EqlStatsResponse.NodeStatsResponse> nodes, List<FailedNodeException> failures) {
        return new EqlStatsResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected EqlStatsRequest.NodeStatsRequest newNodeRequest(EqlStatsRequest request) {
        return new EqlStatsRequest.NodeStatsRequest(request);
    }

    protected EqlStatsResponse.NodeStatsResponse newNodeResponse(StreamInput in) throws IOException {
        return new EqlStatsResponse.NodeStatsResponse(in);
    }

    protected EqlStatsResponse.NodeStatsResponse nodeOperation(EqlStatsRequest.NodeStatsRequest request) {
        EqlStatsResponse.NodeStatsResponse statsResponse = new EqlStatsResponse.NodeStatsResponse(this.clusterService.localNode());
        statsResponse.setStats(this.planExecutor.metrics().stats());
        return statsResponse;
    }
}

