/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.util;

import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.transport.RemoteClusterService;

public class RemoteClusterRegistry {
    private final RemoteClusterService remoteClusterService;
    private final IndicesOptions indicesOptions;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ClusterService clusterService;

    public RemoteClusterRegistry(RemoteClusterService remoteClusterService, IndicesOptions indicesOptions, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.remoteClusterService = remoteClusterService;
        this.indicesOptions = indicesOptions;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public Set<String> versionIncompatibleClusters(String indexPattern) {
        TreeSet<String> incompatibleClusters = new TreeSet<String>();
        for (String clusterAlias : this.clusterAliases(Strings.splitStringByCommaToArray((String)indexPattern), true)) {
            Version clusterVersion = this.remoteClusterService.getConnection(clusterAlias).getVersion();
            if (clusterVersion.equals((Object)Version.CURRENT)) continue;
            incompatibleClusters.add(clusterAlias);
        }
        return incompatibleClusters;
    }

    public Set<String> clusterAliases(String[] indices, boolean discardLocal) {
        Set<String> clusters = this.remoteClusterService.groupIndices(this.indicesOptions, indices, idx -> this.indexNameExpressionResolver.hasIndexAbstraction(idx, this.clusterService.state())).keySet();
        if (discardLocal) {
            clusters.remove("");
        }
        return clusters;
    }
}

