/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.Field;
import org.elasticsearch.xpack.vectors.mapper.VectorEncoderDecoder;

public abstract class VectorScriptDocValues
extends ScriptDocValues<BytesRef> {
    private final BinaryDocValues in;
    final Version indexVersion;
    BytesRef value;

    VectorScriptDocValues(BinaryDocValues in, Version indexVersion) {
        this.in = in;
        this.indexVersion = indexVersion;
    }

    public void setNextDocId(int docId) throws IOException {
        this.value = this.in.advanceExact(docId) ? this.in.binaryValue() : null;
    }

    BytesRef getEncodedValue() {
        return this.value;
    }

    public BytesRef get(int index) {
        throw new UnsupportedOperationException("accessing a vector field's value through 'get' or 'value' is not supported");
    }

    public int size() {
        if (this.value == null) {
            return 0;
        }
        return 1;
    }

    public static class SparseVectorScriptDocValues
    extends VectorScriptDocValues {
        public SparseVectorScriptDocValues(BinaryDocValues in, Version indexVersion) {
            super(in, indexVersion);
        }

        Version indexVersion() {
            return this.indexVersion;
        }

        public Field<BytesRef> toField(String fieldName) {
            throw new IllegalStateException("not implemented");
        }
    }

    public static class DenseVectorScriptDocValues
    extends VectorScriptDocValues {
        private final int dims;
        private final float[] vector;

        public DenseVectorScriptDocValues(BinaryDocValues in, Version indexVersion, int dims) {
            super(in, indexVersion);
            this.dims = dims;
            this.vector = new float[dims];
        }

        @Override
        public BytesRef get(int index) {
            throw new UnsupportedOperationException("accessing a vector field's value through 'get' or 'value' is not supported!Use 'vectorValue' or 'magnitude' instead!'");
        }

        int dims() {
            return this.dims;
        }

        public float[] getVectorValue() {
            VectorEncoderDecoder.decodeDenseVector(this.value, this.vector);
            return this.vector;
        }

        public float getMagnitude() {
            return VectorEncoderDecoder.getMagnitude(this.indexVersion, this.value);
        }

        public BytesRef getNonPrimitiveValue() {
            return this.value;
        }

        public Field<BytesRef> toField(String fieldName) {
            throw new IllegalStateException("not implemented");
        }
    }
}

