/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.EntrySource;
import com.unboundid.ldap.sdk.EntrySourceException;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DNEntrySource
extends EntrySource {
    private final Iterator<?> dnIterator;
    private final LDAPInterface connection;
    private final String[] attributes;

    public DNEntrySource(LDAPInterface connection, DN[] dns, String ... attributes) {
        Validator.ensureNotNull(connection, dns);
        this.connection = connection;
        this.dnIterator = Arrays.asList(dns).iterator();
        this.attributes = attributes == null ? StaticUtils.NO_STRINGS : attributes;
    }

    public DNEntrySource(LDAPInterface connection, String[] dns, String ... attributes) {
        this(connection, Arrays.asList(dns), attributes);
    }

    public DNEntrySource(LDAPInterface connection, Collection<String> dns, String ... attributes) {
        Validator.ensureNotNull(connection, dns);
        this.connection = connection;
        this.dnIterator = dns.iterator();
        this.attributes = attributes == null ? StaticUtils.NO_STRINGS : attributes;
    }

    @Override
    public Entry nextEntry() throws EntrySourceException {
        if (!this.dnIterator.hasNext()) {
            return null;
        }
        String dn = String.valueOf(this.dnIterator.next());
        try {
            SearchResultEntry e = this.connection.getEntry(dn, this.attributes);
            if (e == null) {
                throw new EntrySourceException(true, LDAPMessages.ERR_DN_ENTRY_SOURCE_NO_SUCH_ENTRY.get(dn), new LDAPException(ResultCode.NO_RESULTS_RETURNED));
            }
            return e;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new EntrySourceException(true, LDAPMessages.ERR_DN_ENTRY_SOURCE_ERR_RETRIEVING_ENTRY.get(dn, StaticUtils.getExceptionMessage(le)), le);
        }
    }

    @Override
    public void close() {
    }
}

