/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRolloverAction
extends TransportMasterNodeAction<RolloverRequest, RolloverResponse> {
    private static final Logger logger = LogManager.getLogger(TransportRolloverAction.class);
    private final MetadataRolloverService rolloverService;
    private final ActiveShardsObserver activeShardsObserver;
    private final Client client;

    @Inject
    public TransportRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, Client client) {
        super("indices:admin/rollover", transportService, clusterService, threadPool, actionFilters, RolloverRequest::new, indexNameExpressionResolver, RolloverResponse::new, "same");
        this.rolloverService = rolloverService;
        this.client = client;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
    }

    @Override
    protected ClusterBlockException checkBlock(RolloverRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request));
    }

    @Override
    protected void masterOperation(RolloverRequest request, ClusterState state, ActionListener<RolloverResponse> listener) throws Exception {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected void masterOperation(Task task, final RolloverRequest rolloverRequest, ClusterState oldState, ActionListener<RolloverResponse> listener) throws Exception {
        final Metadata metadata = oldState.metadata();
        IndicesStatsRequest statsRequest = ((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{rolloverRequest.getRolloverTarget()})).clear().indicesOptions(IndicesOptions.fromOptions(true, false, true, true))).docs(true);
        statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute(IndicesStatsAction.INSTANCE, statsRequest, ActionListener.wrap(statsResponse -> {
            MetadataRolloverService.NameResolution trialRolloverNames = this.rolloverService.resolveRolloverNames(oldState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest());
            String trialSourceIndexName = trialRolloverNames.sourceName;
            String trialRolloverIndexName = trialRolloverNames.rolloverName;
            this.rolloverService.validateIndexName(oldState, trialRolloverIndexName);
            Map<String, Boolean> trialConditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditions().values(), TransportRolloverAction.buildStats(metadata.index(trialSourceIndexName), statsResponse));
            if (rolloverRequest.isDryRun()) {
                listener.onResponse(new RolloverResponse(trialSourceIndexName, trialRolloverIndexName, trialConditionResults, true, false, false, false));
                return;
            }
            SetOnce sourceIndex = new SetOnce();
            SetOnce rolloverIndex = new SetOnce();
            SetOnce conditionResults = new SetOnce();
            List trialMetConditions = rolloverRequest.getConditions().values().stream().filter(condition -> (Boolean)trialConditionResults.get(condition.toString())).collect(Collectors.toList());
            if (trialConditionResults.size() == 0 || trialMetConditions.size() > 0) {
                this.clusterService.submitStateUpdateTask("rollover_index source [" + trialRolloverIndexName + "] to target [" + trialRolloverIndexName + "]", new ClusterStateUpdateTask((IndicesStatsResponse)statsResponse, conditionResults, sourceIndex, rolloverIndex, listener, trialSourceIndexName, trialRolloverIndexName, trialConditionResults){
                    final /* synthetic */ IndicesStatsResponse val$statsResponse;
                    final /* synthetic */ SetOnce val$conditionResults;
                    final /* synthetic */ SetOnce val$sourceIndex;
                    final /* synthetic */ SetOnce val$rolloverIndex;
                    final /* synthetic */ ActionListener val$listener;
                    final /* synthetic */ String val$trialSourceIndexName;
                    final /* synthetic */ String val$trialRolloverIndexName;
                    final /* synthetic */ Map val$trialConditionResults;
                    {
                        this.val$statsResponse = indicesStatsResponse;
                        this.val$conditionResults = setOnce;
                        this.val$sourceIndex = setOnce2;
                        this.val$rolloverIndex = setOnce3;
                        this.val$listener = actionListener;
                        this.val$trialSourceIndexName = string;
                        this.val$trialRolloverIndexName = string2;
                        this.val$trialConditionResults = map;
                    }

                    @Override
                    public ClusterState execute(ClusterState currentState) throws Exception {
                        MetadataRolloverService.NameResolution rolloverNames = TransportRolloverAction.this.rolloverService.resolveRolloverNames(currentState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest());
                        String sourceIndexName = rolloverNames.sourceName;
                        Map<String, Boolean> postConditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditions().values(), TransportRolloverAction.buildStats(metadata.index(sourceIndexName), this.val$statsResponse));
                        List<Condition<?>> metConditions = rolloverRequest.getConditions().values().stream().filter(condition -> (Boolean)postConditionResults.get(condition.toString())).collect(Collectors.toList());
                        this.val$conditionResults.set(postConditionResults);
                        if (postConditionResults.size() == 0 || metConditions.size() > 0) {
                            MetadataRolloverService.RolloverResult rolloverResult = TransportRolloverAction.this.rolloverService.rolloverClusterState(currentState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), metConditions, false, false);
                            logger.trace("rollover result [{}]", (Object)rolloverResult);
                            this.val$sourceIndex.set(rolloverResult.sourceIndexName);
                            this.val$rolloverIndex.set(rolloverResult.rolloverIndexName);
                            return rolloverResult.clusterState;
                        }
                        return currentState;
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        this.val$listener.onFailure(e);
                    }

                    @Override
                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        if (!newState.equals(oldState)) {
                            assert (this.val$sourceIndex.get() != null) : "source index missing on successful rollover";
                            assert (this.val$rolloverIndex.get() != null) : "rollover index missing on successful rollover";
                            assert (this.val$conditionResults.get() != null) : "matching rollover conditions missing on successful rollover";
                            TransportRolloverAction.this.activeShardsObserver.waitForActiveShards(new String[]{(String)this.val$rolloverIndex.get()}, rolloverRequest.getCreateIndexRequest().waitForActiveShards(), rolloverRequest.masterNodeTimeout(), isShardsAcknowledged -> this.val$listener.onResponse(new RolloverResponse((String)this.val$sourceIndex.get(), (String)this.val$rolloverIndex.get(), (Map)this.val$conditionResults.get(), false, true, true, (boolean)isShardsAcknowledged)), this.val$listener::onFailure);
                        } else {
                            this.val$listener.onResponse(new RolloverResponse(this.val$trialSourceIndexName, this.val$trialRolloverIndexName, this.val$trialConditionResults, false, false, false, false));
                        }
                    }
                });
            } else {
                listener.onResponse(new RolloverResponse(trialSourceIndexName, trialRolloverIndexName, trialConditionResults, false, false, false, false));
            }
        }, listener::onFailure));
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable Condition.Stats stats) {
        Objects.requireNonNull(conditions, "conditions must not be null");
        if (stats != null) {
            return conditions.stream().map(condition -> condition.evaluate(stats)).collect(Collectors.toMap(result -> result.condition.toString(), result -> result.matched));
        }
        return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
    }

    static Condition.Stats buildStats(@Nullable IndexMetadata metadata, @Nullable IndicesStatsResponse statsResponse) {
        if (metadata == null) {
            return null;
        }
        Optional<IndexStats> indexStats = Optional.ofNullable(statsResponse).map(stats -> stats.getIndex(metadata.getIndex().getName()));
        DocsStats docsStats = indexStats.map(stats -> stats.getPrimaries().getDocs()).orElse(null);
        long maxPrimaryShardSize = TransportRolloverAction.optionalStream(indexStats).map(IndexStats::getShards).filter(Objects::nonNull).flatMap(Arrays::stream).filter(shard -> shard.getShardRouting().primary()).map(ShardStats::getStats).mapToLong(shard -> shard.docs.getTotalSizeInBytes()).max().orElse(0L);
        return new Condition.Stats(docsStats == null ? 0L : docsStats.getCount(), metadata.getCreationDate(), new ByteSizeValue(docsStats == null ? 0L : docsStats.getTotalSizeInBytes()), new ByteSizeValue(maxPrimaryShardSize));
    }

    private static <T> Stream<T> optionalStream(Optional<T> o) {
        if (o.isPresent()) {
            return Stream.of(o.get());
        }
        return Stream.empty();
    }
}

