/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.PersistedClusterStateService;

public class RemoveSettingsCommand
extends ElasticsearchNodeCommand {
    static final String SETTINGS_REMOVED_MSG = "Settings were successfully removed from the cluster state";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have incompatible settings in the\ncluster state that prevent the cluster from forming.\nThis tool can cause data loss and its use should be your last resort.\n\nDo you want to proceed?\n";
    private final OptionSpec<String> arguments;

    public RemoveSettingsCommand() {
        super("Removes persistent settings from the cluster state");
        this.arguments = this.parser.nonOptions("setting names");
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException, UserException {
        List<String> settingsToRemove = this.arguments.values(options);
        if (settingsToRemove.isEmpty()) {
            throw new UserException(64, "Must supply at least one setting to remove");
        }
        PersistedClusterStateService persistedClusterStateService = RemoveSettingsCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        Tuple<Long, ClusterState> termAndClusterState = RemoveSettingsCommand.loadTermAndClusterState(persistedClusterStateService, env);
        ClusterState oldClusterState = termAndClusterState.v2();
        Settings oldPersistentSettings = oldClusterState.metadata().persistentSettings();
        terminal.println(Terminal.Verbosity.VERBOSE, "persistent settings: " + oldPersistentSettings);
        Settings.Builder newPersistentSettingsBuilder = Settings.builder().put(oldPersistentSettings);
        for (String settingToRemove : settingsToRemove) {
            boolean matched = false;
            for (String settingKey : oldPersistentSettings.keySet()) {
                if (!Regex.simpleMatch(settingToRemove, settingKey)) continue;
                newPersistentSettingsBuilder.remove(settingKey);
                if (!matched) {
                    terminal.println("The following settings will be removed:");
                }
                matched = true;
                terminal.println(settingKey + ": " + oldPersistentSettings.get(settingKey));
            }
            if (matched) continue;
            throw new UserException(64, "No persistent cluster settings matching [" + settingToRemove + "] were found on this node");
        }
        ClusterState newClusterState = ClusterState.builder(oldClusterState).metadata(Metadata.builder(oldClusterState.metadata()).persistentSettings(newPersistentSettingsBuilder.build()).build()).build();
        terminal.println(Terminal.Verbosity.VERBOSE, "[old cluster state = " + oldClusterState + ", new cluster state = " + newClusterState + "]");
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit(termAndClusterState.v1(), newClusterState);
        }
        terminal.println(SETTINGS_REMOVED_MSG);
    }
}

