/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.QueueResizingEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ResizableBlockingQueue;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.TimedRunnable;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;

public class EsExecutors {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(EsExecutors.class);
    public static final Setting<Integer> PROCESSORS_SETTING = new Setting<Integer>("processors", s -> Integer.toString(Runtime.getRuntime().availableProcessors()), EsExecutors.processorsParser("processors"), Setting.Property.Deprecated, Setting.Property.NodeScope);
    public static final Setting<Integer> NODE_PROCESSORS_SETTING = new Setting<Integer>("node.processors", PROCESSORS_SETTING, EsExecutors.processorsParser("node.processors"), Setting.Property.NodeScope);
    public static final ExecutorService DIRECT_EXECUTOR_SERVICE = new DirectExecutorService();

    private static Function<String, Integer> processorsParser(String name) {
        return s -> {
            int availableProcessors;
            int value = Setting.parseInt(s, 1, name);
            if (value > (availableProcessors = Runtime.getRuntime().availableProcessors())) {
                deprecationLogger.deprecate(DeprecationCategory.SETTINGS, "processors", "setting [{}] to value [{}] which is more than available processors [{}] is deprecated", name, value, availableProcessors);
            }
            return value;
        };
    }

    public static int allocatedProcessors(Settings settings) {
        return NODE_PROCESSORS_SETTING.get(settings);
    }

    public static PrioritizedEsThreadPoolExecutor newSinglePrioritizing(String name, ThreadFactory threadFactory, ThreadContext contextHolder, ScheduledExecutorService timer, PrioritizedEsThreadPoolExecutor.StarvationWatcher starvationWatcher) {
        return new PrioritizedEsThreadPoolExecutor(name, 1, 1, 0L, TimeUnit.MILLISECONDS, threadFactory, contextHolder, timer, starvationWatcher);
    }

    public static EsThreadPoolExecutor newScaling(String name, int min, int max, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, ThreadContext contextHolder) {
        ExecutorScalingQueue<Runnable> queue = new ExecutorScalingQueue<Runnable>();
        EsThreadPoolExecutor executor = new EsThreadPoolExecutor(name, min, max, keepAliveTime, unit, queue, threadFactory, new ForceQueuePolicy(), contextHolder);
        queue.executor = executor;
        return executor;
    }

    public static EsThreadPoolExecutor newFixed(String name, int size, int queueCapacity, ThreadFactory threadFactory, ThreadContext contextHolder) {
        BlockingQueue<Runnable> queue = queueCapacity < 0 ? ConcurrentCollections.newBlockingQueue() : new SizeBlockingQueue(ConcurrentCollections.newBlockingQueue(), queueCapacity);
        return new EsThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, queue, threadFactory, new EsAbortPolicy(), contextHolder);
    }

    public static EsThreadPoolExecutor newAutoQueueFixed(String name, int size, int initialQueueCapacity, int minQueueSize, int maxQueueSize, int frameSize, TimeValue targetedResponseTime, ThreadFactory threadFactory, ThreadContext contextHolder) {
        if (initialQueueCapacity <= 0) {
            throw new IllegalArgumentException("initial queue capacity for [" + name + "] executor must be positive, got: " + initialQueueCapacity);
        }
        ResizableBlockingQueue<Runnable> queue = new ResizableBlockingQueue<Runnable>(ConcurrentCollections.newBlockingQueue(), initialQueueCapacity);
        return new QueueResizingEsThreadPoolExecutor(name, size, size, 0L, TimeUnit.MILLISECONDS, queue, minQueueSize, maxQueueSize, TimedRunnable::new, frameSize, targetedResponseTime, threadFactory, new EsAbortPolicy(), contextHolder);
    }

    public static Throwable rethrowErrors(Runnable runnable) {
        block7: {
            if (runnable instanceof RunnableFuture) {
                assert (((RunnableFuture)runnable).isDone());
                try {
                    ((RunnableFuture)runnable).get();
                }
                catch (Exception e) {
                    assert (e instanceof CancellationException || e instanceof InterruptedException || e instanceof ExecutionException) : e;
                    Optional<Error> maybeError = ExceptionsHelper.maybeError(e);
                    if (maybeError.isPresent()) {
                        throw maybeError.get();
                    }
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(e instanceof ExecutionException)) break block7;
                    return e.getCause();
                }
            }
        }
        return null;
    }

    public static String threadName(Settings settings, String namePrefix) {
        if (Node.NODE_NAME_SETTING.exists(settings)) {
            return EsExecutors.threadName(Node.NODE_NAME_SETTING.get(settings), namePrefix);
        }
        return EsExecutors.threadName("", namePrefix);
    }

    public static String threadName(String nodeName, String namePrefix) {
        return "elasticsearch" + (nodeName.isEmpty() ? "" : "[") + nodeName + (nodeName.isEmpty() ? "" : "]") + "[" + namePrefix + "]";
    }

    public static ThreadFactory daemonThreadFactory(Settings settings, String namePrefix) {
        return EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String nodeName, String namePrefix) {
        assert (nodeName != null && !nodeName.isEmpty());
        return EsExecutors.daemonThreadFactory(EsExecutors.threadName(nodeName, namePrefix));
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        return new EsThreadFactory(namePrefix);
    }

    private EsExecutors() {
    }

    static class ExecutorScalingQueue<E>
    extends LinkedTransferQueue<E> {
        ThreadPoolExecutor executor;

        ExecutorScalingQueue() {
        }

        @Override
        public boolean offer(E e) {
            if (!this.tryTransfer(e)) {
                int left = this.executor.getMaximumPoolSize() - this.executor.getCorePoolSize();
                if (left > 0) {
                    return false;
                }
                return super.offer(e);
            }
            return true;
        }
    }

    static class ForceQueuePolicy
    implements XRejectedExecutionHandler {
        ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                assert (executor.getQueue() instanceof ExecutorScalingQueue);
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public long rejected() {
            return 0L;
        }
    }

    static class EsThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        EsThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + "[T#" + this.threadNumber.getAndIncrement() + "]", 0L);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class DirectExecutorService
    extends AbstractExecutorService {
        @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
        DirectExecutorService() {
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            command.run();
            EsExecutors.rethrowErrors(command);
        }
    }
}

